/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.runtime.metrics.groups.ReporterScopedSettings;

public class FrontMetricGroup<P extends AbstractMetricGroup<?>>
extends ProxyMetricGroup<P> {
    @VisibleForTesting
    static final char DEFAULT_REPLACEMENT = '_';
    @VisibleForTesting
    static final char DEFAULT_REPLACEMENT_ALTERNATIVE = '-';
    private final ReporterScopedSettings settings;

    public FrontMetricGroup(ReporterScopedSettings settings, P reference) {
        super(reference);
        this.settings = settings;
    }

    @Override
    public String getMetricIdentifier(String metricName) {
        return ((AbstractMetricGroup)this.parentMetricGroup).getMetricIdentifier(metricName, FrontMetricGroup.getDelimiterFilter(this.settings, CharacterFilter.NO_OP_FILTER), this.settings.getReporterIndex(), this.settings.getDelimiter());
    }

    @Override
    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        return ((AbstractMetricGroup)this.parentMetricGroup).getMetricIdentifier(metricName, FrontMetricGroup.getDelimiterFilter(this.settings, filter), this.settings.getReporterIndex(), this.settings.getDelimiter());
    }

    @Override
    public Map<String, String> getAllVariables() {
        return ((AbstractMetricGroup)this.parentMetricGroup).getAllVariables(this.settings.getReporterIndex(), this.settings.getExcludedVariables());
    }

    public String getLogicalScope(CharacterFilter filter) {
        return ((AbstractMetricGroup)this.parentMetricGroup).getLogicalScope(FrontMetricGroup.getDelimiterFilter(this.settings, filter), this.settings.getDelimiter());
    }

    public String getLogicalScope(CharacterFilter filter, char delimiter) {
        return ((AbstractMetricGroup)this.parentMetricGroup).getLogicalScope(FrontMetricGroup.getDelimiterFilter(this.settings, filter), delimiter, this.settings.getReporterIndex());
    }

    private static CharacterFilter getDelimiterFilter(ReporterScopedSettings reporterScopedSettings, CharacterFilter generalCharacterFilter) {
        if (reporterScopedSettings.getDelimiter() != '_') {
            return input -> generalCharacterFilter.filterCharacters(input.replace(reporterScopedSettings.getDelimiter(), '_'));
        }
        return input -> generalCharacterFilter.filterCharacters(input.replace(reporterScopedSettings.getDelimiter(), '-'));
    }
}

