/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;

public class SlotManagerUtils {
    public static ResourceProfile generateDefaultSlotResourceProfile(WorkerResourceSpec workerResourceSpec, int numSlotsPerWorker) {
        ResourceProfile.Builder resourceProfileBuilder = ResourceProfile.newBuilder().setCpuCores((CPUResource)workerResourceSpec.getCpuCores().divide(numSlotsPerWorker)).setTaskHeapMemory(workerResourceSpec.getTaskHeapSize().divide((long)numSlotsPerWorker)).setTaskOffHeapMemory(workerResourceSpec.getTaskOffHeapSize().divide((long)numSlotsPerWorker)).setManagedMemory(workerResourceSpec.getManagedMemSize().divide((long)numSlotsPerWorker)).setNetworkMemory(workerResourceSpec.getNetworkMemSize().divide((long)numSlotsPerWorker));
        workerResourceSpec.getExtendedResources().forEach((name, resource) -> resourceProfileBuilder.setExtendedResource((ExternalResource)resource.divide(numSlotsPerWorker)));
        return resourceProfileBuilder.build();
    }

    public static ResourceProfile generateDefaultSlotResourceProfile(ResourceProfile resourceProfile, int numSlotsPerWorker) {
        ResourceProfile.Builder resourceProfileBuilder = ResourceProfile.newBuilder().setCpuCores((CPUResource)resourceProfile.getCpuCores().divide(numSlotsPerWorker)).setTaskHeapMemory(resourceProfile.getTaskHeapMemory().divide((long)numSlotsPerWorker)).setTaskOffHeapMemory(resourceProfile.getTaskOffHeapMemory().divide((long)numSlotsPerWorker)).setManagedMemory(resourceProfile.getManagedMemory().divide((long)numSlotsPerWorker)).setNetworkMemory(resourceProfile.getNetworkMemory().divide((long)numSlotsPerWorker));
        resourceProfile.getExtendedResources().forEach((name, resource) -> resourceProfileBuilder.setExtendedResource((ExternalResource)resource.divide(numSlotsPerWorker)));
        return resourceProfileBuilder.build();
    }

    public static int calculateDefaultNumSlots(ResourceProfile totalResourceProfile, ResourceProfile defaultSlotResourceProfile) {
        if (totalResourceProfile.equals(ResourceProfile.ANY)) {
            return Integer.MAX_VALUE;
        }
        int numSlots = 0;
        ResourceProfile remainResource = totalResourceProfile;
        while (remainResource.allFieldsNoLessThan(defaultSlotResourceProfile)) {
            remainResource = remainResource.subtract(defaultSlotResourceProfile);
            ++numSlots;
        }
        return numSlots;
    }

    public static ResourceProfile getEffectiveResourceProfile(ResourceProfile requirement, ResourceProfile defaultResourceProfile) {
        return requirement.equals(ResourceProfile.UNKNOWN) ? defaultResourceProfile : requirement;
    }

    public static ResourceProfile generateTaskManagerTotalResourceProfile(WorkerResourceSpec workerResourceSpec) {
        return ResourceProfile.newBuilder().setCpuCores(workerResourceSpec.getCpuCores()).setTaskHeapMemory(workerResourceSpec.getTaskHeapSize()).setTaskOffHeapMemory(workerResourceSpec.getTaskOffHeapSize()).setManagedMemory(workerResourceSpec.getManagedMemSize()).setNetworkMemory(workerResourceSpec.getNetworkMemSize()).setExtendedResources(workerResourceSpec.getExtendedResources().values()).build();
    }
}

