/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.akka;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

final class AkkaRpcSerializedValue
implements Serializable {
    private static final long serialVersionUID = -4388571068440835689L;
    @Nullable
    private final byte[] serializedData;

    private AkkaRpcSerializedValue(@Nullable byte[] serializedData) {
        this.serializedData = serializedData;
    }

    @Nullable
    public byte[] getSerializedData() {
        return this.serializedData;
    }

    public int getSerializedDataLength() {
        return this.serializedData == null ? 0 : this.serializedData.length;
    }

    @Nullable
    public <T> T deserializeValue(ClassLoader loader) throws IOException, ClassNotFoundException {
        Preconditions.checkNotNull((Object)loader, (String)"No classloader has been passed");
        return (T)(this.serializedData == null ? null : InstantiationUtil.deserializeObject((byte[])this.serializedData, (ClassLoader)loader));
    }

    public static AkkaRpcSerializedValue valueOf(@Nullable Object value) throws IOException {
        byte[] serializedData = value == null ? null : InstantiationUtil.serializeObject((Object)value);
        return new AkkaRpcSerializedValue(serializedData);
    }

    public boolean equals(Object o) {
        if (o instanceof AkkaRpcSerializedValue) {
            AkkaRpcSerializedValue other = (AkkaRpcSerializedValue)o;
            return Arrays.equals(this.serializedData, other.serializedData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedData);
    }

    public String toString() {
        return this.serializedData == null ? "AkkaRpcSerializedValue(null)" : "AkkaRpcSerializedValue";
    }
}

