/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.FailureHandlingResultSnapshot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class RootExceptionHistoryEntry
extends ExceptionHistoryEntry {
    private static final long serialVersionUID = -7647332765867297434L;
    private final Set<ExceptionHistoryEntry> concurrentExceptions;

    public static RootExceptionHistoryEntry fromFailureHandlingResultSnapshot(FailureHandlingResultSnapshot snapshot) {
        String failingTaskName = null;
        TaskManagerLocation taskManagerLocation = null;
        if (snapshot.getRootCauseExecution().isPresent()) {
            Execution rootCauseExecution = snapshot.getRootCauseExecution().get();
            failingTaskName = rootCauseExecution.getVertexWithAttempt();
            taskManagerLocation = rootCauseExecution.getAssignedResourceLocation();
        }
        return RootExceptionHistoryEntry.createRootExceptionHistoryEntry(snapshot.getRootCause(), snapshot.getTimestamp(), failingTaskName, taskManagerLocation, snapshot.getConcurrentlyFailedExecution());
    }

    public static RootExceptionHistoryEntry fromGlobalFailure(Throwable cause, long timestamp, Iterable<Execution> executions) {
        return RootExceptionHistoryEntry.createRootExceptionHistoryEntry(cause, timestamp, null, null, executions);
    }

    private static RootExceptionHistoryEntry createRootExceptionHistoryEntry(Throwable cause, long timestamp, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation, Iterable<Execution> executions) {
        return new RootExceptionHistoryEntry(cause, timestamp, failingTaskName, taskManagerLocation, StreamSupport.stream(executions.spliterator(), false).filter(execution -> execution.getFailureInfo().isPresent()).map(execution -> ExceptionHistoryEntry.create(execution, execution.getVertexWithAttempt())).collect(Collectors.toSet()));
    }

    @VisibleForTesting
    public RootExceptionHistoryEntry(Throwable cause, long timestamp, @Nullable String failingTaskName, @Nullable TaskManagerLocation taskManagerLocation, Set<ExceptionHistoryEntry> concurrentExceptions) {
        super(cause, timestamp, failingTaskName, taskManagerLocation);
        this.concurrentExceptions = concurrentExceptions;
    }

    public Iterable<ExceptionHistoryEntry> getConcurrentExceptions() {
        return this.concurrentExceptions;
    }
}

