/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateBackendOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.util.Preconditions;

@Internal
public class LatencyTrackingStateConfig {
    private final MetricGroup metricGroup;
    private final boolean enabled;
    private final int sampleInterval;
    private final int historySize;

    LatencyTrackingStateConfig(MetricGroup metricGroup, boolean enabled, int sampleInterval, int historySize) {
        if (enabled) {
            Preconditions.checkNotNull((Object)metricGroup, (String)"Metric group cannot be null if latency tracking is enabled.");
            Preconditions.checkArgument((sampleInterval >= 1 ? 1 : 0) != 0);
        }
        this.metricGroup = metricGroup;
        this.enabled = enabled;
        this.sampleInterval = sampleInterval;
        this.historySize = historySize;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getSampleInterval() {
        return this.sampleInterval;
    }

    public static LatencyTrackingStateConfig disabled() {
        return LatencyTrackingStateConfig.newBuilder().setEnabled(false).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean enabled = (Boolean)StateBackendOptions.LATENCY_TRACK_ENABLED.defaultValue();
        private int sampleInterval = (Integer)StateBackendOptions.LATENCY_TRACK_SAMPLE_INTERVAL.defaultValue();
        private int historySize = (Integer)StateBackendOptions.LATENCY_TRACK_HISTORY_SIZE.defaultValue();
        private MetricGroup metricGroup;

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setSampleInterval(int sampleInterval) {
            this.sampleInterval = sampleInterval;
            return this;
        }

        public Builder setHistorySize(int historySize) {
            this.historySize = historySize;
            return this;
        }

        public Builder setMetricGroup(MetricGroup metricGroup) {
            this.metricGroup = metricGroup;
            return this;
        }

        public Builder configure(ReadableConfig config) {
            this.setEnabled((Boolean)config.get(StateBackendOptions.LATENCY_TRACK_ENABLED)).setSampleInterval((Integer)config.get(StateBackendOptions.LATENCY_TRACK_SAMPLE_INTERVAL)).setHistorySize((Integer)config.get(StateBackendOptions.LATENCY_TRACK_HISTORY_SIZE));
            return this;
        }

        public LatencyTrackingStateConfig build() {
            return new LatencyTrackingStateConfig(this.metricGroup, this.enabled, this.sampleInterval, this.historySize);
        }
    }
}

