/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.IntCounter;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.junit.Assert;
import org.junit.Test;

public class StringifiedAccumulatorResultTest {
    @Test
    public void testSerialization() throws IOException {
        String name = "a";
        String type = "b";
        String value = "c";
        StringifiedAccumulatorResult original = new StringifiedAccumulatorResult("a", "b", "c");
        Assert.assertEquals((Object)"a", (Object)original.getName());
        Assert.assertEquals((Object)"b", (Object)original.getType());
        Assert.assertEquals((Object)"c", (Object)original.getValue());
        StringifiedAccumulatorResult copy = (StringifiedAccumulatorResult)CommonTestUtils.createCopySerializable((Serializable)original);
        Assert.assertEquals((Object)"a", (Object)copy.getName());
        Assert.assertEquals((Object)"b", (Object)copy.getType());
        Assert.assertEquals((Object)"c", (Object)copy.getValue());
    }

    @Test
    public void stringifyingResultsShouldIncorporateAccumulatorLocalValueDirectly() {
        String name = "a";
        int targetValue = 314159;
        IntCounter acc = new IntCounter();
        acc.add(314159);
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.of((Object)acc));
        StringifiedAccumulatorResult[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assert.assertEquals((long)1L, (long)results.length);
        StringifiedAccumulatorResult firstResult = results[0];
        Assert.assertEquals((Object)"a", (Object)firstResult.getName());
        Assert.assertEquals((Object)"IntCounter", (Object)firstResult.getType());
        Assert.assertEquals((Object)Integer.toString(314159), (Object)firstResult.getValue());
    }

    @Test
    public void stringifyingResultsShouldReportNullLocalValueAsNonnullValueString() {
        String name = "a";
        NullBearingAccumulator acc = new NullBearingAccumulator();
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.of((Object)acc));
        StringifiedAccumulatorResult[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assert.assertEquals((long)1L, (long)results.length);
        StringifiedAccumulatorResult firstResult = results[0];
        Assert.assertEquals((Object)"a", (Object)firstResult.getName());
        Assert.assertEquals((Object)"NullBearingAccumulator", (Object)firstResult.getType());
        Assert.assertEquals((Object)"null", (Object)firstResult.getValue());
    }

    @Test
    public void stringifyingResultsShouldReportNullAccumulatorWithNonnullValueAndTypeString() {
        String name = "a";
        HashMap<String, Object> accumulatorMap = new HashMap<String, Object>();
        accumulatorMap.put("a", null);
        StringifiedAccumulatorResult[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assert.assertEquals((long)1L, (long)results.length);
        StringifiedAccumulatorResult firstResult = results[0];
        Assert.assertEquals((Object)"a", (Object)firstResult.getName());
        Assert.assertEquals((Object)"null", (Object)firstResult.getType());
        Assert.assertEquals((Object)"null", (Object)firstResult.getValue());
    }

    @Test
    public void stringifyingFailureResults() {
        String name = "a";
        HashMap<String, OptionalFailure> accumulatorMap = new HashMap<String, OptionalFailure>();
        accumulatorMap.put("a", OptionalFailure.ofFailure((Throwable)new FlinkRuntimeException("Test")));
        StringifiedAccumulatorResult[] results = StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulatorMap);
        Assert.assertEquals((long)1L, (long)results.length);
        StringifiedAccumulatorResult firstResult = results[0];
        Assert.assertEquals((Object)"a", (Object)firstResult.getName());
        Assert.assertEquals((Object)"null", (Object)firstResult.getType());
        Assert.assertTrue((boolean)firstResult.getValue().startsWith("org.apache.flink.util.FlinkRuntimeException: Test"));
    }

    private static class NullBearingAccumulator
    implements SimpleAccumulator<Serializable> {
        private NullBearingAccumulator() {
        }

        public void add(Serializable value) {
            throw new UnsupportedOperationException();
        }

        public Serializable getLocalValue() {
            return null;
        }

        public void resetLocal() {
            throw new UnsupportedOperationException();
        }

        public void merge(Accumulator<Serializable, Serializable> other) {
            throw new UnsupportedOperationException();
        }

        public Accumulator<Serializable, Serializable> clone() {
            return new NullBearingAccumulator();
        }
    }
}

