/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.blob.BlobClientTest;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.net.SSLUtilsTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobClientSslTest
extends BlobClientTest {
    private static BlobClientTest.TestBlobServer blobSslServer;
    private static BlobServer blobNonSslServer;
    private static Configuration sslClientConfig;
    private static Configuration nonSslClientConfig;
    @ClassRule
    public static TemporaryFolder temporarySslFolder;

    @BeforeClass
    public static void startSSLServer() throws IOException {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores((String)SecurityOptions.SSL_PROVIDER.defaultValue());
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, temporarySslFolder.newFolder().getAbsolutePath());
        blobSslServer = new BlobClientTest.TestBlobServer(config, (BlobStore)new VoidBlobStore());
        blobSslServer.start();
        sslClientConfig = config;
    }

    @BeforeClass
    public static void startNonSSLServer() throws IOException {
        Configuration config = SSLUtilsTest.createInternalSslConfigWithKeyAndTrustStores((String)SecurityOptions.SSL_PROVIDER.defaultValue());
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, temporarySslFolder.newFolder().getAbsolutePath());
        config.setBoolean(BlobServerOptions.SSL_ENABLED, false);
        blobNonSslServer = new BlobServer(config, (BlobStore)new VoidBlobStore());
        blobNonSslServer.start();
        nonSslClientConfig = config;
    }

    @AfterClass
    public static void stopServers() throws IOException {
        if (blobSslServer != null) {
            blobSslServer.close();
        }
        if (blobNonSslServer != null) {
            blobNonSslServer.close();
        }
    }

    @Override
    protected boolean isSSLEnabled() {
        return true;
    }

    @Override
    protected Configuration getBlobClientConfig() {
        return sslClientConfig;
    }

    @Override
    protected BlobClientTest.TestBlobServer getBlobServer() {
        return blobSslServer;
    }

    @Override
    @Test
    public void testUploadJarFilesHelper() throws Exception {
        BlobClientSslTest.uploadJarFile(blobSslServer, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLClientFailure() throws Exception {
        BlobClientSslTest.uploadJarFile(blobServer, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLClientFailure2() throws Exception {
        BlobClientSslTest.uploadJarFile(blobNonSslServer, sslClientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLServerFailure() throws Exception {
        BlobClientSslTest.uploadJarFile(blobSslServer, clientConfig);
    }

    @Test(expected=IOException.class)
    public void testSSLServerFailure2() throws Exception {
        BlobClientSslTest.uploadJarFile(blobSslServer, nonSslClientConfig);
    }

    @Test
    public void testNonSSLConnection() throws Exception {
        BlobClientSslTest.uploadJarFile(blobServer, clientConfig);
    }

    @Test
    public void testNonSSLConnection2() throws Exception {
        BlobClientSslTest.uploadJarFile(blobServer, nonSslClientConfig);
    }

    @Test
    public void testNonSSLConnection3() throws Exception {
        BlobClientSslTest.uploadJarFile(blobNonSslServer, clientConfig);
    }

    @Test
    public void testNonSSLConnection4() throws Exception {
        BlobClientSslTest.uploadJarFile(blobNonSslServer, nonSslClientConfig);
    }

    static {
        temporarySslFolder = new TemporaryFolder();
    }
}

