/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.hooks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.MasterTriggerRestoreHook;
import org.apache.flink.util.Preconditions;

public class TestMasterHook
implements MasterTriggerRestoreHook<String> {
    private static final String DEFAULT_STATE = "default";
    private final String id;
    private int restoreCount = 0;
    private boolean failOnRestore = false;

    private TestMasterHook(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public static TestMasterHook fromId(String id) {
        return new TestMasterHook(id);
    }

    public String getIdentifier() {
        return this.id;
    }

    public CompletableFuture<String> triggerCheckpoint(long checkpointId, long timestamp, Executor executor) {
        return CompletableFuture.completedFuture(DEFAULT_STATE);
    }

    public void restoreCheckpoint(long checkpointId, @Nullable String checkpointData) throws Exception {
        ++this.restoreCount;
        if (this.failOnRestore) {
            throw new Exception("Failing mast hook state restore on purpose.");
        }
    }

    public SimpleVersionedSerializer<String> createCheckpointDataSerializer() {
        return new CheckpointCoordinatorTestingUtils.StringSerializer();
    }

    public int getRestoreCount() {
        return this.restoreCount;
    }

    public void enableFailOnRestore() {
        this.failOnRestore = true;
    }

    public void disableFailOnRestore() {
        this.failOnRestore = false;
    }
}

