/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.runtime.rpc.MainThreadValidatorUtil;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;

public class ComponentMainThreadExecutorServiceAdapter
implements ComponentMainThreadExecutor {
    private final ScheduledExecutor scheduledExecutor;
    private final Runnable mainThreadCheck;

    public ComponentMainThreadExecutorServiceAdapter(ScheduledExecutorService scheduledExecutorService, Thread mainThread) {
        this((ScheduledExecutor)new ScheduledExecutorServiceAdapter(scheduledExecutorService), mainThread);
    }

    public ComponentMainThreadExecutorServiceAdapter(ScheduledExecutor scheduledExecutor, Thread mainThread) {
        this.scheduledExecutor = scheduledExecutor;
        this.mainThreadCheck = () -> {
            assert (MainThreadValidatorUtil.isRunningInExpectedThread((Thread)mainThread));
        };
    }

    public static ComponentMainThreadExecutor forMainThread() {
        final Thread main = Thread.currentThread();
        return new ComponentMainThreadExecutorServiceAdapter(new DirectScheduledExecutorService(){

            @Override
            public void execute(Runnable command) {
                assert (MainThreadValidatorUtil.isRunningInExpectedThread((Thread)main));
                super.execute(command);
            }
        }, main);
    }

    public static ComponentMainThreadExecutor forSingleThreadExecutor(@Nonnull ScheduledExecutorService singleThreadExecutor) {
        Thread thread = CompletableFuture.supplyAsync(Thread::currentThread, singleThreadExecutor).join();
        return new ComponentMainThreadExecutorServiceAdapter(singleThreadExecutor, thread);
    }

    public void assertRunningInMainThread() {
        this.mainThreadCheck.run();
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.scheduledExecutor.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduledExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.scheduledExecutor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public void execute(Runnable command) {
        this.scheduledExecutor.execute(command);
    }
}

