/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import org.apache.flink.runtime.entrypoint.ClusterEntryPointExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ClusterEntryPointExceptionUtilsTest
extends TestLogger {
    @Test
    public void testDirectMemoryOOMHandling() {
        OutOfMemoryError error = new OutOfMemoryError("Direct buffer memory");
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError((Throwable)error);
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)ClusterEntryPointExceptionUtils.JM_DIRECT_OOM_ERROR_MESSAGE));
    }

    @Test
    public void testMetaspaceOOMHandling() {
        OutOfMemoryError error = new OutOfMemoryError("Metaspace");
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError((Throwable)error);
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)ClusterEntryPointExceptionUtils.JM_METASPACE_OOM_ERROR_MESSAGE));
    }

    @Test
    public void testHeapSpaceOOMHandling() {
        OutOfMemoryError error = new OutOfMemoryError("Java heap space");
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError((Throwable)error);
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)ClusterEntryPointExceptionUtils.JM_HEAP_SPACE_OOM_ERROR_MESSAGE));
    }

    @Test
    public void testAnyOtherOOMHandling() {
        String message = "Any other message won't be changed.";
        OutOfMemoryError error = new OutOfMemoryError(message);
        ClusterEntryPointExceptionUtils.tryEnrichClusterEntryPointError((Throwable)error);
        Assert.assertThat((Object)error.getMessage(), (Matcher)Matchers.is((Object)message));
    }
}

