/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import org.apache.flink.runtime.executiongraph.AllVerticesIterator;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.junit.Assert;
import org.junit.Test;

public class AllVerticesIteratorTest {
    @Test
    public void testAllVertices() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            v1.setInvokableClass(AbstractInvokable.class);
            v2.setInvokableClass(AbstractInvokable.class);
            v3.setInvokableClass(AbstractInvokable.class);
            v4.setInvokableClass(AbstractInvokable.class);
            v1.setParallelism(1);
            v2.setParallelism(7);
            v3.setParallelism(3);
            v4.setParallelism(2);
            DefaultExecutionGraph eg = ExecutionGraphTestUtils.createSimpleTestGraph(v1, v2, v3, v4);
            ExecutionJobVertex ejv1 = eg.getJobVertex(v1.getID());
            ExecutionJobVertex ejv2 = eg.getJobVertex(v2.getID());
            ExecutionJobVertex ejv3 = eg.getJobVertex(v3.getID());
            ExecutionJobVertex ejv4 = eg.getJobVertex(v4.getID());
            AllVerticesIterator iter = new AllVerticesIterator(Arrays.asList(ejv1, ejv2, ejv3, ejv4).iterator());
            int numReturned = 0;
            while (iter.hasNext()) {
                iter.hasNext();
                Assert.assertNotNull((Object)iter.next());
                ++numReturned;
            }
            Assert.assertEquals((long)13L, (long)numReturned);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

