/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.messages.Acknowledge;

class InteractionsCountingTaskManagerGateway
extends SimpleAckingTaskManagerGateway {
    private final AtomicInteger cancelTaskCount = new AtomicInteger(0);
    private final AtomicInteger submitTaskCount = new AtomicInteger(0);
    private CountDownLatch submitLatch;

    public InteractionsCountingTaskManagerGateway() {
        this.submitLatch = new CountDownLatch(0);
    }

    public InteractionsCountingTaskManagerGateway(int expectedSubmitCount) {
        this.submitLatch = new CountDownLatch(expectedSubmitCount);
    }

    @Override
    public CompletableFuture<Acknowledge> cancelTask(ExecutionAttemptID executionAttemptID, Time timeout) {
        this.cancelTaskCount.incrementAndGet();
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    @Override
    public CompletableFuture<Acknowledge> submitTask(TaskDeploymentDescriptor tdd, Time timeout) {
        this.submitTaskCount.incrementAndGet();
        this.submitLatch.countDown();
        return CompletableFuture.completedFuture(Acknowledge.get());
    }

    void resetCounts() {
        this.cancelTaskCount.set(0);
        this.submitTaskCount.set(0);
    }

    int getCancelTaskCount() {
        return this.cancelTaskCount.get();
    }

    int getSubmitTaskCount() {
        return this.submitTaskCount.get();
    }

    int getInteractionsCount() {
        return this.cancelTaskCount.get() + this.submitTaskCount.get();
    }

    void waitUntilAllTasksAreSubmitted() {
        try {
            this.submitLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

