/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointSerializationTest {
    private static final byte[] STORAGE_LOCATION_REF = new byte[]{15, 52, 52, 11, 0, 0, 0, 0, -1, -23, -19, 35};

    @Test
    public void testSuspendingCheckpointBarrierSerialization() throws Exception {
        CheckpointOptions suspendSavepointToSerialize = new CheckpointOptions(CheckpointType.SAVEPOINT_SUSPEND, new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        this.testCheckpointBarrierSerialization(suspendSavepointToSerialize);
    }

    @Test
    public void testSavepointBarrierSerialization() throws Exception {
        CheckpointOptions savepointToSerialize = new CheckpointOptions(CheckpointType.SAVEPOINT, new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        this.testCheckpointBarrierSerialization(savepointToSerialize);
    }

    @Test
    public void testCheckpointBarrierSerialization() throws Exception {
        CheckpointOptions checkpointToSerialize = new CheckpointOptions(CheckpointType.CHECKPOINT, new CheckpointStorageLocationReference(STORAGE_LOCATION_REF));
        this.testCheckpointBarrierSerialization(checkpointToSerialize);
    }

    @Test
    public void testCheckpointWithDefaultLocationSerialization() throws Exception {
        CheckpointOptions checkpointToSerialize = CheckpointOptions.forCheckpointWithDefaultLocation();
        this.testCheckpointBarrierSerialization(checkpointToSerialize);
    }

    private void testCheckpointBarrierSerialization(CheckpointOptions options) throws IOException {
        long checkpointId = 2147606770L;
        long timestamp = 2147484875L;
        CheckpointBarrier barrierBeforeSerialization = new CheckpointBarrier(2147606770L, 2147484875L, options);
        CheckpointBarrier barrierAfterDeserialization = this.serializeAndDeserializeCheckpointBarrier(barrierBeforeSerialization);
        Assert.assertEquals((Object)barrierBeforeSerialization, (Object)barrierAfterDeserialization);
    }

    private CheckpointBarrier serializeAndDeserializeCheckpointBarrier(CheckpointBarrier barrierUnderTest) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ByteBuffer serialized = EventSerializer.toSerializedEvent((AbstractEvent)barrierUnderTest);
        CheckpointBarrier deserialized = (CheckpointBarrier)EventSerializer.fromSerializedEvent((ByteBuffer)serialized, (ClassLoader)cl);
        Assert.assertFalse((boolean)serialized.hasRemaining());
        return deserialized;
    }
}

