/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.netty.CreditBasedSequenceNumberingViewReader;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.netty.PartitionRequestServerHandler;
import org.apache.flink.runtime.io.network.partition.PartitionNotFoundException;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PartitionRequestServerHandlerTest
extends TestLogger {
    @Test
    public void testResponsePartitionNotFoundException() {
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler((ResultPartitionProvider)new ResultPartitionManager(), (TaskEventPublisher)new TaskEventDispatcher(), new PartitionRequestQueue());
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{serverHandler});
        ResultPartitionID partitionId = new ResultPartitionID();
        channel.writeInbound(new Object[]{new NettyMessage.PartitionRequest(partitionId, 0, new InputChannelID(), 2)});
        channel.runPendingTasks();
        Object msg = channel.readOutbound();
        Assert.assertThat((Object)msg, (Matcher)Matchers.instanceOf(NettyMessage.ErrorResponse.class));
        NettyMessage.ErrorResponse err = (NettyMessage.ErrorResponse)msg;
        Assert.assertThat((Object)err.cause, (Matcher)Matchers.instanceOf(PartitionNotFoundException.class));
        ResultPartitionID actualPartitionId = ((PartitionNotFoundException)err.cause).getPartitionId();
        Assert.assertThat((Object)partitionId, (Matcher)Matchers.is((Object)actualPartitionId));
    }

    @Test
    public void testResumeConsumption() {
        InputChannelID inputChannelID = new InputChannelID();
        PartitionRequestQueue partitionRequestQueue = new PartitionRequestQueue();
        TestViewReader testViewReader = new TestViewReader(inputChannelID, 2, partitionRequestQueue);
        PartitionRequestServerHandler serverHandler = new PartitionRequestServerHandler((ResultPartitionProvider)new ResultPartitionManager(), (TaskEventPublisher)new TaskEventDispatcher(), partitionRequestQueue);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{serverHandler});
        partitionRequestQueue.notifyReaderCreated((NetworkSequenceViewReader)testViewReader);
        channel.writeInbound(new Object[]{new NettyMessage.ResumeConsumption(inputChannelID)});
        channel.runPendingTasks();
        Assert.assertTrue((boolean)testViewReader.consumptionResumed);
    }

    private static class TestViewReader
    extends CreditBasedSequenceNumberingViewReader {
        private boolean consumptionResumed = false;

        TestViewReader(InputChannelID receiverId, int initialCredit, PartitionRequestQueue requestQueue) {
            super(receiverId, initialCredit, requestQueue);
        }

        public void resumeConsumption() {
            this.consumptionResumed = true;
        }
    }
}

