/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.NoSuchElementException;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.junit.Assert;
import org.junit.Test;

public class PrioritizedDequeTest {
    @Test
    public void testPrioritizeOnAdd() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)3);
        deque.add((Object)3, true, true);
        Assert.assertArrayEquals((Object[])new Integer[]{3, 0, 1, 2}, (Object[])deque.asUnmodifiableCollection().toArray(new Integer[0]));
    }

    @Test
    public void testPrioritize() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)3);
        deque.prioritize((Object)3);
        Assert.assertArrayEquals((Object[])new Integer[]{3, 0, 1, 2}, (Object[])deque.asUnmodifiableCollection().toArray(new Integer[0]));
    }

    @Test
    public void testGetAndRemove() {
        PrioritizedDeque deque = new PrioritizedDeque();
        deque.add((Object)0);
        deque.add((Object)1);
        deque.add((Object)2);
        deque.add((Object)1);
        deque.add((Object)3);
        Assert.assertEquals((long)1L, (long)((Integer)deque.getAndRemove(v -> v == 1)).intValue());
        Assert.assertArrayEquals((Object[])new Integer[]{0, 2, 1, 3}, (Object[])deque.asUnmodifiableCollection().toArray(new Integer[0]));
        Assert.assertEquals((long)1L, (long)((Integer)deque.getAndRemove(v -> v == 1)).intValue());
        Assert.assertArrayEquals((Object[])new Integer[]{0, 2, 3}, (Object[])deque.asUnmodifiableCollection().toArray(new Integer[0]));
        try {
            int removed = (Integer)deque.getAndRemove(v -> v == 1);
            Assert.fail((String)String.format("This should not happen. Item [%s] was removed, but it shouldn't be found", removed));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }
}

