/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobmaster.DefaultExecutionDeploymentReconciler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentReconciliationHandler;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentState;
import org.apache.flink.runtime.taskexecutor.ExecutionDeploymentReport;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.Test;

public class DefaultExecutionDeploymentReconcilerTest
extends TestLogger {
    @Test
    public void testMatchingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = new ExecutionAttemptID();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.singleton(attemptId)), Collections.singletonMap(attemptId, ExecutionDeploymentState.DEPLOYED));
        Assert.assertThat(handler.getMissingExecutions(), (Matcher)Matchers.empty());
        Assert.assertThat(handler.getUnknownExecutions(), (Matcher)Matchers.empty());
    }

    @Test
    public void testMissingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = new ExecutionAttemptID();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.emptySet()), Collections.singletonMap(attemptId, ExecutionDeploymentState.DEPLOYED));
        Assert.assertThat(handler.getUnknownExecutions(), (Matcher)Matchers.empty());
        Assert.assertThat(handler.getMissingExecutions(), (Matcher)IsCollectionContaining.hasItem((Object)attemptId));
    }

    @Test
    public void testUnknownDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID attemptId = new ExecutionAttemptID();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(Collections.singleton(attemptId)), Collections.emptyMap());
        Assert.assertThat(handler.getMissingExecutions(), (Matcher)Matchers.empty());
        Assert.assertThat(handler.getUnknownExecutions(), (Matcher)IsCollectionContaining.hasItem((Object)attemptId));
    }

    @Test
    public void testMissingAndUnknownDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID unknownId = new ExecutionAttemptID();
        ExecutionAttemptID missingId = new ExecutionAttemptID();
        ExecutionAttemptID matchingId = new ExecutionAttemptID();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(new HashSet<ExecutionAttemptID>(Arrays.asList(unknownId, matchingId))), Stream.of(missingId, matchingId).collect(Collectors.toMap(x -> x, x -> ExecutionDeploymentState.DEPLOYED)));
        Assert.assertThat(handler.getMissingExecutions(), (Matcher)IsCollectionContaining.hasItem((Object)missingId));
        Assert.assertThat(handler.getUnknownExecutions(), (Matcher)IsCollectionContaining.hasItem((Object)unknownId));
    }

    @Test
    public void testPendingDeployments() {
        TestingExecutionDeploymentReconciliationHandler handler = new TestingExecutionDeploymentReconciliationHandler();
        DefaultExecutionDeploymentReconciler reconciler = new DefaultExecutionDeploymentReconciler((ExecutionDeploymentReconciliationHandler)handler);
        ResourceID resourceId = ResourceID.generate();
        ExecutionAttemptID matchingId = new ExecutionAttemptID();
        ExecutionAttemptID unknownId = new ExecutionAttemptID();
        ExecutionAttemptID missingId = new ExecutionAttemptID();
        reconciler.reconcileExecutionDeployments(resourceId, new ExecutionDeploymentReport(new HashSet<ExecutionAttemptID>(Arrays.asList(matchingId, unknownId))), Stream.of(matchingId, missingId).collect(Collectors.toMap(x -> x, x -> ExecutionDeploymentState.PENDING)));
        Assert.assertThat(handler.getMissingExecutions(), (Matcher)Matchers.empty());
        Assert.assertThat(handler.getUnknownExecutions(), (Matcher)IsCollectionContaining.hasItem((Object)unknownId));
    }

    private static class TestingExecutionDeploymentReconciliationHandler
    implements ExecutionDeploymentReconciliationHandler {
        private final Collection<ExecutionAttemptID> missingExecutions = new ArrayList<ExecutionAttemptID>();
        private final Collection<ExecutionAttemptID> unknownExecutions = new ArrayList<ExecutionAttemptID>();

        private TestingExecutionDeploymentReconciliationHandler() {
        }

        public void onMissingDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID hostingTaskExecutor) {
            this.missingExecutions.addAll(executionAttemptIds);
        }

        public void onUnknownDeploymentsOf(Collection<ExecutionAttemptID> executionAttemptIds, ResourceID hostingTaskExecutor) {
            this.unknownExecutions.addAll(executionAttemptIds);
        }

        public Collection<ExecutionAttemptID> getMissingExecutions() {
            return this.missingExecutions;
        }

        public Collection<ExecutionAttemptID> getUnknownExecutions() {
            return this.unknownExecutions;
        }
    }
}

