/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.Checkpoints;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

public class TestUtils {
    public static File createSavepointWithOperatorState(File savepointFile, long savepointId, OperatorID ... operatorIds) throws IOException {
        Collection<OperatorState> operatorStates = TestUtils.createOperatorState(operatorIds);
        CheckpointMetadata savepoint = new CheckpointMetadata(savepointId, operatorStates, Collections.emptyList());
        try (FileOutputStream fileOutputStream = new FileOutputStream(savepointFile);){
            Checkpoints.storeCheckpointMetadata((CheckpointMetadata)savepoint, (OutputStream)fileOutputStream);
        }
        return savepointFile;
    }

    private static Collection<OperatorState> createOperatorState(OperatorID ... operatorIds) {
        Random random = new Random();
        ArrayList<OperatorState> operatorStates = new ArrayList<OperatorState>(operatorIds.length);
        for (OperatorID operatorId : operatorIds) {
            OperatorState operatorState = new OperatorState(operatorId, 1, 42);
            OperatorSubtaskState subtaskState = OperatorSubtaskState.builder().setManagedOperatorState((OperatorStateHandle)new OperatorStreamStateHandle(Collections.emptyMap(), (StreamStateHandle)new ByteStreamStateHandle("foobar", new byte[0]))).setInputChannelState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewInputChannelStateHandle(10, random))).setResultSubpartitionState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewResultSubpartitionStateHandle(10, random))).build();
            operatorState.putState(0, subtaskState);
            operatorStates.add(operatorState);
        }
        return operatorStates;
    }

    @Nonnull
    public static JobGraph createJobGraphFromJobVerticesWithCheckpointing(SavepointRestoreSettings savepointRestoreSettings, JobVertex ... jobVertices) {
        CheckpointCoordinatorConfiguration checkpoinCoordinatorConfiguration = CheckpointCoordinatorConfiguration.builder().setCheckpointInterval(1000L).setCheckpointTimeout(1000L).setMinPauseBetweenCheckpoints(1000L).setMaxConcurrentCheckpoints(1).setCheckpointRetentionPolicy(CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION).setExactlyOnce(true).setUnalignedCheckpointsEnabled(false).setPreferCheckpointForRecovery(false).setTolerableCheckpointFailureNumber(0).build();
        JobCheckpointingSettings checkpointingSettings = new JobCheckpointingSettings(checkpoinCoordinatorConfiguration, null);
        return JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertices(Arrays.asList(jobVertices)).setJobCheckpointingSettings(checkpointingSettings).setSavepointRestoreSettings(savepointRestoreSettings).build();
    }

    private TestUtils() {
        throw new UnsupportedOperationException("This class should not be instantiated.");
    }
}

