/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulk;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequestBulkWithTimestamp;

class TestingPhysicalSlotRequestBulkBuilder {
    private static final BiConsumer<SlotRequestId, Throwable> EMPTY_CANCELLER = (r, t) -> {};
    private Map<SlotRequestId, ResourceProfile> pendingRequests = new HashMap<SlotRequestId, ResourceProfile>();
    private BiConsumer<SlotRequestId, Throwable> canceller = EMPTY_CANCELLER;

    TestingPhysicalSlotRequestBulkBuilder() {
    }

    TestingPhysicalSlotRequestBulkBuilder addPendingRequest(SlotRequestId slotRequestId, ResourceProfile resourceProfile) {
        this.pendingRequests.put(slotRequestId, resourceProfile);
        return this;
    }

    TestingPhysicalSlotRequestBulkBuilder setCanceller(BiConsumer<SlotRequestId, Throwable> canceller) {
        this.canceller = canceller;
        return this;
    }

    PhysicalSlotRequestBulkImpl buildPhysicalSlotRequestBulkImpl() {
        return new PhysicalSlotRequestBulkImpl(this.pendingRequests, this.canceller);
    }

    PhysicalSlotRequestBulkWithTimestamp buildPhysicalSlotRequestBulkWithTimestamp() {
        return new PhysicalSlotRequestBulkWithTimestamp((PhysicalSlotRequestBulk)this.buildPhysicalSlotRequestBulkImpl());
    }

    static TestingPhysicalSlotRequestBulkBuilder newBuilder() {
        return new TestingPhysicalSlotRequestBulkBuilder();
    }
}

