/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

public class TestingSlotPoolImpl
extends SlotPoolImpl {
    private ResourceProfile lastRequestedSlotResourceProfile;
    private volatile Consumer<SlotRequestId> releaseSlotConsumer = null;
    private volatile Consumer<SlotRequestId> timeoutPendingSlotRequestConsumer = null;

    public TestingSlotPoolImpl(JobID jobId) {
        this(jobId, (Clock)SystemClock.getInstance(), AkkaUtils.getDefaultTimeout(), AkkaUtils.getDefaultTimeout(), Time.milliseconds((long)((Long)JobManagerOptions.SLOT_IDLE_TIMEOUT.defaultValue())));
    }

    public TestingSlotPoolImpl(JobID jobId, Clock clock, Time rpcTimeout, Time idleSlotTimeout, Time batchSlotTimeout) {
        super(jobId, clock, rpcTimeout, idleSlotTimeout, batchSlotTimeout);
    }

    void triggerCheckIdleSlot() {
        this.runAsync(() -> ((TestingSlotPoolImpl)this).checkIdleSlot());
    }

    void triggerCheckBatchSlotTimeout() {
        this.runAsync(() -> ((TestingSlotPoolImpl)this).checkBatchSlotTimeout());
    }

    boolean isBatchSlotRequestTimeoutCheckEnabled() {
        return this.batchSlotRequestTimeoutCheckEnabled;
    }

    public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, @Nullable Time timeout) {
        this.lastRequestedSlotResourceProfile = resourceProfile;
        return super.requestNewAllocatedSlot(slotRequestId, resourceProfile, timeout);
    }

    public ResourceProfile getLastRequestedSlotResourceProfile() {
        return this.lastRequestedSlotResourceProfile;
    }

    public void setReleaseSlotConsumer(Consumer<SlotRequestId> releaseSlotConsumer) {
        this.releaseSlotConsumer = (Consumer)Preconditions.checkNotNull(releaseSlotConsumer);
    }

    public void setTimeoutPendingSlotRequestConsumer(Consumer<SlotRequestId> timeoutPendingSlotRequestConsumer) {
        this.timeoutPendingSlotRequestConsumer = (Consumer)Preconditions.checkNotNull(timeoutPendingSlotRequestConsumer);
    }

    public void releaseSlot(SlotRequestId slotRequestId, @Nullable Throwable cause) {
        Consumer<SlotRequestId> currentReleaseSlotConsumer = this.releaseSlotConsumer;
        super.releaseSlot(slotRequestId, cause);
        if (currentReleaseSlotConsumer != null) {
            currentReleaseSlotConsumer.accept(slotRequestId);
        }
    }

    protected void timeoutPendingSlotRequest(SlotRequestId slotRequestId) {
        Consumer<SlotRequestId> currentTimeoutPendingSlotRequestConsumer = this.timeoutPendingSlotRequestConsumer;
        super.timeoutPendingSlotRequest(slotRequestId);
        if (currentTimeoutPendingSlotRequestConsumer != null) {
            currentTimeoutPendingSlotRequestConsumer.accept(slotRequestId);
        }
    }

    boolean containsAllocatedSlot(AllocationID allocationId) {
        return this.getAllocatedSlots().contains(allocationId);
    }

    boolean containsAvailableSlot(AllocationID allocationId) {
        return this.getAvailableSlots().contains(allocationId);
    }

    int getNumberOfPendingRequests() {
        return this.getPendingRequests().size();
    }

    int getNumberOfWaitingForResourceRequests() {
        return this.getWaitingForResourceManager().size();
    }
}

