/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriverFactory;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.rpc.FatalErrorHandler;

public class TestingLeaderElectionDriver
implements LeaderElectionDriver {
    private final Object lock = new Object();
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private final LeaderElectionEventHandler leaderElectionEventHandler;
    private final FatalErrorHandler fatalErrorHandler;
    private LeaderInformation leaderInformation = LeaderInformation.empty();

    private TestingLeaderElectionDriver(LeaderElectionEventHandler leaderElectionEventHandler, FatalErrorHandler fatalErrorHandler) {
        this.leaderElectionEventHandler = leaderElectionEventHandler;
        this.fatalErrorHandler = fatalErrorHandler;
    }

    public void writeLeaderInformation(LeaderInformation leaderInformation) {
        this.leaderInformation = leaderInformation;
    }

    public boolean hasLeadership() {
        return this.isLeader.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
        }
    }

    public LeaderInformation getLeaderInformation() {
        return this.leaderInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isLeader() {
        Object object = this.lock;
        synchronized (object) {
            this.isLeader.set(true);
            this.leaderElectionEventHandler.onGrantLeadership();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notLeader() {
        Object object = this.lock;
        synchronized (object) {
            this.isLeader.set(false);
            this.leaderElectionEventHandler.onRevokeLeadership();
        }
    }

    public void leaderInformationChanged(LeaderInformation newLeader) {
        this.leaderInformation = newLeader;
        this.leaderElectionEventHandler.onLeaderInformationChange(newLeader);
    }

    public void onFatalError(Throwable throwable) {
        this.fatalErrorHandler.onFatalError(throwable);
    }

    public static class TestingLeaderElectionDriverFactory
    implements LeaderElectionDriverFactory {
        private TestingLeaderElectionDriver currentLeaderDriver;

        public LeaderElectionDriver createLeaderElectionDriver(LeaderElectionEventHandler leaderEventHandler, FatalErrorHandler fatalErrorHandler, String leaderContenderDescription) {
            this.currentLeaderDriver = new TestingLeaderElectionDriver(leaderEventHandler, fatalErrorHandler);
            return this.currentLeaderDriver;
        }

        @Nullable
        public TestingLeaderElectionDriver getCurrentLeaderDriver() {
            return this.currentLeaderDriver;
        }
    }
}

