/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormats;
import org.apache.flink.util.function.TriConsumer;

public class TestingMetricRegistry
implements MetricRegistry {
    private final char delimiter;
    private final int numberReporters;
    private final TriConsumer<Metric, String, AbstractMetricGroup<?>> registerConsumer;
    private final TriConsumer<Metric, String, AbstractMetricGroup<?>> unregisterConsumer;
    private final ScopeFormats scopeFormats;

    private TestingMetricRegistry(char delimiter, int numberReporters, TriConsumer<Metric, String, AbstractMetricGroup<?>> registerConsumer, TriConsumer<Metric, String, AbstractMetricGroup<?>> unregisterConsumer, ScopeFormats scopeFormats) {
        this.delimiter = delimiter;
        this.numberReporters = numberReporters;
        this.registerConsumer = registerConsumer;
        this.unregisterConsumer = unregisterConsumer;
        this.scopeFormats = scopeFormats;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public int getNumberReporters() {
        return this.numberReporters;
    }

    public void register(Metric metric, String metricName, AbstractMetricGroup group) {
        this.registerConsumer.accept((Object)metric, (Object)metricName, (Object)group);
    }

    public void unregister(Metric metric, String metricName, AbstractMetricGroup group) {
        this.unregisterConsumer.accept((Object)metric, (Object)metricName, (Object)group);
    }

    public ScopeFormats getScopeFormats() {
        return this.scopeFormats;
    }

    public static TestingMetricRegistryBuilder builder() {
        return new TestingMetricRegistryBuilder();
    }

    public static class TestingMetricRegistryBuilder {
        private char delimiter = (char)46;
        private int numberReporters = 0;
        private TriConsumer<Metric, String, AbstractMetricGroup<?>> registerConsumer = (ignoreMetric, ignoreMetricName, ignoreGroup) -> {};
        private TriConsumer<Metric, String, AbstractMetricGroup<?>> unregisterConsumer = (ignoreMetric, ignoreMetricName, ignoreGroup) -> {};
        private ScopeFormats scopeFormats = ScopeFormats.fromConfig((Configuration)new Configuration());

        private TestingMetricRegistryBuilder() {
        }

        public TestingMetricRegistryBuilder setDelimiter(char delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public TestingMetricRegistryBuilder setNumberReporters(int numberReporters) {
            this.numberReporters = numberReporters;
            return this;
        }

        public TestingMetricRegistryBuilder setRegisterConsumer(TriConsumer<Metric, String, AbstractMetricGroup<?>> registerConsumer) {
            this.registerConsumer = registerConsumer;
            return this;
        }

        public TestingMetricRegistryBuilder setUnregisterConsumer(TriConsumer<Metric, String, AbstractMetricGroup<?>> unregisterConsumer) {
            this.unregisterConsumer = unregisterConsumer;
            return this;
        }

        public TestingMetricRegistryBuilder setScopeFormats(ScopeFormats scopeFormats) {
            this.scopeFormats = scopeFormats;
            return this;
        }

        public TestingMetricRegistry build() {
            return new TestingMetricRegistry(this.delimiter, this.numberReporters, this.registerConsumer, this.unregisterConsumer, this.scopeFormats);
        }
    }
}

