/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils.types;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.operators.testutils.types.IntPair;

public class IntPairComparator
extends TypeComparator<IntPair> {
    private static final long serialVersionUID = 1L;
    private int reference;
    private final TypeComparator[] comparators = new TypeComparator[]{new IntComparator(true)};

    public int hash(IntPair object) {
        return object.getKey() * 73;
    }

    public void setReference(IntPair toCompare) {
        this.reference = toCompare.getKey();
    }

    public boolean equalToReference(IntPair candidate) {
        return candidate.getKey() == this.reference;
    }

    public int compareToReference(TypeComparator<IntPair> referencedAccessors) {
        IntPairComparator comp = (IntPairComparator)referencedAccessors;
        return comp.reference - this.reference;
    }

    public int compare(IntPair first, IntPair second) {
        return first.getKey() - second.getKey();
    }

    public int compareSerialized(DataInputView source1, DataInputView source2) throws IOException {
        return source1.readInt() - source2.readInt();
    }

    public boolean supportsNormalizedKey() {
        return true;
    }

    public int getNormalizeKeyLen() {
        return 4;
    }

    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 4;
    }

    public void putNormalizedKey(IntPair record, MemorySegment target, int offset, int len) {
        block5: {
            int value;
            block4: {
                value = record.getKey() - Integer.MIN_VALUE;
                if (len != 4) break block4;
                target.putIntBigEndian(offset, value);
                break block5;
            }
            if (len <= 0) break block5;
            if (len < 4) {
                int i = 0;
                while (len > 0) {
                    target.put(offset + i, (byte)(value >>> (3 - i << 3) & 0xFF));
                    --len;
                    ++i;
                }
            } else {
                target.putIntBigEndian(offset, value);
                for (int i = 4; i < len; ++i) {
                    target.put(offset + i, (byte)0);
                }
            }
        }
    }

    public boolean invertNormalizedKey() {
        return false;
    }

    public IntPairComparator duplicate() {
        return new IntPairComparator();
    }

    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = ((IntPair)record).getKey();
        return 1;
    }

    public TypeComparator[] getFlatComparators() {
        return this.comparators;
    }

    public boolean supportsSerializationWithKeyNormalization() {
        return true;
    }

    public void writeWithKeyNormalization(IntPair record, DataOutputView target) throws IOException {
        target.writeInt(record.getKey() - Integer.MIN_VALUE);
        target.writeInt(record.getValue());
    }

    public IntPair readWithKeyDenormalization(IntPair reuse, DataInputView source) throws IOException {
        reuse.setKey(source.readInt() + Integer.MIN_VALUE);
        reuse.setValue(source.readInt());
        return reuse;
    }
}

