/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.persistence;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.persistence.IntegerResourceVersion;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.flink.util.function.RunnableWithException;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.ThrowingConsumer;

public class TestingStateHandleStore<T extends Serializable>
implements StateHandleStore<T, IntegerResourceVersion> {
    private final BiFunctionWithException<String, T, RetrievableStateHandle<T>, Exception> addFunction;
    private final ThrowingConsumer<Tuple3<String, IntegerResourceVersion, T>, Exception> replaceConsumer;
    private final FunctionWithException<String, IntegerResourceVersion, Exception> existsFunction;
    private final FunctionWithException<String, RetrievableStateHandle<T>, Exception> getFunction;
    private final SupplierWithException<List<Tuple2<RetrievableStateHandle<T>, String>>, Exception> getAllSupplier;
    private final SupplierWithException<Collection<String>, Exception> getAllHandlesSupplier;
    private final FunctionWithException<String, Boolean, Exception> removeFunction;
    private final RunnableWithException removeAllRunnable;
    private final RunnableWithException clearEntriesRunnable;
    private final ThrowingConsumer<String, Exception> releaseConsumer;
    private final RunnableWithException releaseAllHandlesRunnable;

    private TestingStateHandleStore(BiFunctionWithException<String, T, RetrievableStateHandle<T>, Exception> addFunction, ThrowingConsumer<Tuple3<String, IntegerResourceVersion, T>, Exception> replaceConsumer, FunctionWithException<String, IntegerResourceVersion, Exception> existsFunction, FunctionWithException<String, RetrievableStateHandle<T>, Exception> getFunction, SupplierWithException<List<Tuple2<RetrievableStateHandle<T>, String>>, Exception> getAllSupplier, SupplierWithException<Collection<String>, Exception> getAllHandlesSupplier, FunctionWithException<String, Boolean, Exception> removeFunction, RunnableWithException removeAllRunnable, RunnableWithException clearEntriesRunnable, ThrowingConsumer<String, Exception> releaseConsumer, RunnableWithException releaseAllHandlesRunnable) {
        this.addFunction = addFunction;
        this.replaceConsumer = replaceConsumer;
        this.existsFunction = existsFunction;
        this.getFunction = getFunction;
        this.getAllSupplier = getAllSupplier;
        this.getAllHandlesSupplier = getAllHandlesSupplier;
        this.removeFunction = removeFunction;
        this.removeAllRunnable = removeAllRunnable;
        this.clearEntriesRunnable = clearEntriesRunnable;
        this.releaseConsumer = releaseConsumer;
        this.releaseAllHandlesRunnable = releaseAllHandlesRunnable;
    }

    @Nullable
    public RetrievableStateHandle<T> addAndLock(String name, T state) throws Exception {
        return (RetrievableStateHandle)this.addFunction.apply((Object)name, state);
    }

    public void replace(String name, IntegerResourceVersion resourceVersion, T state) throws Exception {
        this.replaceConsumer.accept((Object)new Tuple3((Object)name, (Object)resourceVersion, state));
    }

    public IntegerResourceVersion exists(String name) throws Exception {
        return (IntegerResourceVersion)this.existsFunction.apply((Object)name);
    }

    @Nullable
    public RetrievableStateHandle<T> getAndLock(String name) throws Exception {
        return (RetrievableStateHandle)this.getFunction.apply((Object)name);
    }

    public List<Tuple2<RetrievableStateHandle<T>, String>> getAllAndLock() throws Exception {
        return (List)this.getAllSupplier.get();
    }

    public Collection<String> getAllHandles() throws Exception {
        return (Collection)this.getAllHandlesSupplier.get();
    }

    public boolean releaseAndTryRemove(String name) throws Exception {
        return (Boolean)this.removeFunction.apply((Object)name);
    }

    public void releaseAndTryRemoveAll() throws Exception {
        this.removeAllRunnable.run();
    }

    public void clearEntries() throws Exception {
        this.clearEntriesRunnable.run();
    }

    public void release(String name) throws Exception {
        this.releaseConsumer.accept((Object)name);
    }

    public void releaseAll() throws Exception {
        this.releaseAllHandlesRunnable.run();
    }

    public static <T extends Serializable> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T extends Serializable> {
        private BiFunctionWithException<String, T, RetrievableStateHandle<T>, Exception> addFunction = (ignore, state) -> null;
        private ThrowingConsumer<Tuple3<String, IntegerResourceVersion, T>, Exception> replaceConsumer = ignore -> {};
        private FunctionWithException<String, IntegerResourceVersion, Exception> existsFunction = ignore -> IntegerResourceVersion.notExisting();
        private FunctionWithException<String, RetrievableStateHandle<T>, Exception> getFunction = ignore -> null;
        private SupplierWithException<List<Tuple2<RetrievableStateHandle<T>, String>>, Exception> getAllSupplier = Collections::emptyList;
        private SupplierWithException<Collection<String>, Exception> getAllHandlesSupplier = Collections::emptyList;
        private FunctionWithException<String, Boolean, Exception> removeFunction = ignore -> false;
        private RunnableWithException removeAllRunnable = () -> {};
        private RunnableWithException clearEntriesRunnable = () -> {};
        private ThrowingConsumer<String, Exception> releaseConsumer = ignore -> {};
        private RunnableWithException releaseAllHandlesRunnable = () -> {};

        private Builder() {
        }

        public Builder<T> setAddFunction(BiFunctionWithException<String, T, RetrievableStateHandle<T>, Exception> addFunction) {
            this.addFunction = addFunction;
            return this;
        }

        public Builder<T> setReplaceConsumer(ThrowingConsumer<Tuple3<String, IntegerResourceVersion, T>, Exception> replaceConsumer) {
            this.replaceConsumer = replaceConsumer;
            return this;
        }

        public Builder<T> setExistsFunction(FunctionWithException<String, IntegerResourceVersion, Exception> existsFunction) {
            this.existsFunction = existsFunction;
            return this;
        }

        public Builder<T> setGetFunction(FunctionWithException<String, RetrievableStateHandle<T>, Exception> getFunction) {
            this.getFunction = getFunction;
            return this;
        }

        public Builder<T> setGetAllSupplier(SupplierWithException<List<Tuple2<RetrievableStateHandle<T>, String>>, Exception> getAllSupplier) {
            this.getAllSupplier = getAllSupplier;
            return this;
        }

        public Builder<T> setGetAllHandlesSupplier(SupplierWithException<Collection<String>, Exception> getAllHandlesSupplier) {
            this.getAllHandlesSupplier = getAllHandlesSupplier;
            return this;
        }

        public Builder<T> setRemoveFunction(FunctionWithException<String, Boolean, Exception> removeFunction) {
            this.removeFunction = removeFunction;
            return this;
        }

        public Builder<T> setRemoveAllRunnable(RunnableWithException removeAllRunnable) {
            this.removeAllRunnable = removeAllRunnable;
            return this;
        }

        public Builder<T> setClearEntriesRunnable(RunnableWithException clearEntriesRunnable) {
            this.clearEntriesRunnable = clearEntriesRunnable;
            return this;
        }

        public Builder<T> setReleaseConsumer(ThrowingConsumer<String, Exception> releaseConsumer) {
            this.releaseConsumer = releaseConsumer;
            return this;
        }

        public Builder<T> setReleaseAllHandlesRunnable(RunnableWithException releaseAllHandlesRunnable) {
            this.releaseAllHandlesRunnable = releaseAllHandlesRunnable;
            return this;
        }

        public TestingStateHandleStore<T> build() {
            return new TestingStateHandleStore(this.addFunction, this.replaceConsumer, this.existsFunction, this.getFunction, this.getAllSupplier, this.getAllHandlesSupplier, this.removeFunction, this.removeAllRunnable, this.clearEntriesRunnable, this.releaseConsumer, this.releaseAllHandlesRunnable);
        }
    }
}

