/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.registration.TestRegistrationGateway;
import org.apache.flink.util.FlinkException;

public class DefaultTestRegistrationGateway
implements TestRegistrationGateway {
    private final String address;
    private final String hostname;
    private final BiFunction<UUID, Long, CompletableFuture<RegistrationResponse>> registrationFunction;

    private DefaultTestRegistrationGateway(String address, String hostname, BiFunction<UUID, Long, CompletableFuture<RegistrationResponse>> registrationFunction) {
        this.address = address;
        this.hostname = hostname;
        this.registrationFunction = registrationFunction;
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    @Override
    public CompletableFuture<RegistrationResponse> registrationCall(UUID leaderId, long timeout) {
        return this.registrationFunction.apply(leaderId, timeout);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String address = "localhost";
        private String hostname = "localhost";
        private BiFunction<UUID, Long, CompletableFuture<RegistrationResponse>> registrationFunction = (ignoredA, ignoredB) -> CompletableFuture.completedFuture(new RegistrationResponse.Failure((Throwable)new FlinkException("Not configured")));

        public Builder setAddress(String address) {
            this.address = address;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder setRegistrationFunction(BiFunction<UUID, Long, CompletableFuture<RegistrationResponse>> registrationFunction) {
            this.registrationFunction = registrationFunction;
            return this;
        }

        public DefaultTestRegistrationGateway build() {
            return new DefaultTestRegistrationGateway(this.address, this.hostname, this.registrationFunction);
        }
    }
}

