/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationResult;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerResourceInfoProvider;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerInfo;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingTaskManagerResourceInfoProvider;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.util.ResourceCounter;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DefaultResourceAllocationStrategyTest
extends TestLogger {
    private static final ResourceProfile DEFAULT_SLOT_RESOURCE = ResourceProfile.fromResources((double)1.0, (int)100);
    private static final int NUM_OF_SLOTS = 5;
    private static final DefaultResourceAllocationStrategy STRATEGY = new DefaultResourceAllocationStrategy(DEFAULT_SLOT_RESOURCE.multiply(5), 5);

    @Test
    public void testFulfillRequirementWithRegisteredResources() {
        TestingTaskManagerInfo taskManager = new TestingTaskManagerInfo(DEFAULT_SLOT_RESOURCE.multiply(10), DEFAULT_SLOT_RESOURCE.multiply(10), DEFAULT_SLOT_RESOURCE);
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile largeResource = DEFAULT_SLOT_RESOURCE.multiply(8);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setRegisteredTaskManagersSupplier(() -> Collections.singleton(taskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)largeResource, (int)1));
        requirements.add(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)2));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider);
        Assert.assertThat((Object)result.getUnfulfillableJobs(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat(result.getAllocationsOnPendingResources().keySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)result.getPendingTaskManagersToAllocate(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)((ResourceCounter)((Map)result.getAllocationsOnRegisteredResources().get(jobId)).get(taskManager.getInstanceId())).getResourceCount(DEFAULT_SLOT_RESOURCE), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)((ResourceCounter)((Map)result.getAllocationsOnRegisteredResources().get(jobId)).get(taskManager.getInstanceId())).getResourceCount(largeResource), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testFulfillRequirementWithPendingResources() {
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile largeResource = DEFAULT_SLOT_RESOURCE.multiply(3);
        PendingTaskManager pendingTaskManager = new PendingTaskManager(DEFAULT_SLOT_RESOURCE.multiply(5), 5);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setPendingTaskManagersSupplier(() -> Collections.singleton(pendingTaskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)largeResource, (int)1));
        requirements.add(ResourceRequirement.create((ResourceProfile)ResourceProfile.UNKNOWN, (int)7));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider);
        Assert.assertThat((Object)result.getUnfulfillableJobs(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat(result.getAllocationsOnRegisteredResources().keySet(), (Matcher)Is.is((Matcher)Matchers.empty()));
        Assert.assertThat((Object)result.getPendingTaskManagersToAllocate().size(), (Matcher)Is.is((Object)1));
        PendingTaskManagerId newAllocated = ((PendingTaskManager)result.getPendingTaskManagersToAllocate().get(0)).getPendingTaskManagerId();
        ResourceCounter allFulfilledRequirements = ResourceCounter.empty();
        for (Map.Entry resourceWithCount : ((ResourceCounter)((Map)result.getAllocationsOnPendingResources().get(pendingTaskManager.getPendingTaskManagerId())).get(jobId)).getResourcesWithCount()) {
            allFulfilledRequirements = allFulfilledRequirements.add((ResourceProfile)resourceWithCount.getKey(), ((Integer)resourceWithCount.getValue()).intValue());
        }
        for (Map.Entry resourceWithCount : ((ResourceCounter)((Map)result.getAllocationsOnPendingResources().get(newAllocated)).get(jobId)).getResourcesWithCount()) {
            allFulfilledRequirements = allFulfilledRequirements.add((ResourceProfile)resourceWithCount.getKey(), ((Integer)resourceWithCount.getValue()).intValue());
        }
        Assert.assertThat((Object)allFulfilledRequirements.getResourceCount(DEFAULT_SLOT_RESOURCE), (Matcher)Is.is((Object)7));
        Assert.assertThat((Object)allFulfilledRequirements.getResourceCount(largeResource), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testUnfulfillableRequirement() {
        TestingTaskManagerInfo taskManager = new TestingTaskManagerInfo(DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE.multiply(5), DEFAULT_SLOT_RESOURCE);
        JobID jobId = new JobID();
        ArrayList<ResourceRequirement> requirements = new ArrayList<ResourceRequirement>();
        ResourceProfile unfulfillableResource = DEFAULT_SLOT_RESOURCE.multiply(8);
        TestingTaskManagerResourceInfoProvider taskManagerResourceInfoProvider = TestingTaskManagerResourceInfoProvider.newBuilder().setRegisteredTaskManagersSupplier(() -> Collections.singleton(taskManager)).build();
        requirements.add(ResourceRequirement.create((ResourceProfile)unfulfillableResource, (int)1));
        ResourceAllocationResult result = STRATEGY.tryFulfillRequirements(Collections.singletonMap(jobId, requirements), (TaskManagerResourceInfoProvider)taskManagerResourceInfoProvider);
        Assert.assertThat((Object)result.getUnfulfillableJobs(), (Matcher)Matchers.contains((Object[])new JobID[]{jobId}));
        Assert.assertThat((Object)result.getPendingTaskManagersToAllocate(), (Matcher)Is.is((Matcher)Matchers.empty()));
    }
}

