/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.runtime.concurrent.Executors;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfiguration;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerImpl;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.runtime.testingUtils.TestingUtils;

public class SlotManagerBuilder {
    private SlotMatchingStrategy slotMatchingStrategy = AnyMatchingSlotMatchingStrategy.INSTANCE;
    private ScheduledExecutor scheduledExecutor = TestingUtils.defaultScheduledExecutor();
    private Time taskManagerRequestTimeout = TestingUtils.infiniteTime();
    private Time slotRequestTimeout = TestingUtils.infiniteTime();
    private Time taskManagerTimeout = TestingUtils.infiniteTime();
    private boolean waitResultConsumedBeforeRelease = true;
    private WorkerResourceSpec defaultWorkerResourceSpec = WorkerResourceSpec.ZERO;
    private int numSlotsPerWorker = 1;
    private SlotManagerMetricGroup slotManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredSlotManagerMetricGroup();
    private int maxSlotNum = (Integer)ResourceManagerOptions.MAX_SLOT_NUM.defaultValue();
    private int redundantTaskManagerNum = (Integer)ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM.defaultValue();

    private SlotManagerBuilder() {
    }

    public static SlotManagerBuilder newBuilder() {
        return new SlotManagerBuilder();
    }

    public SlotManagerBuilder setScheduledExecutor(ScheduledExecutor scheduledExecutor) {
        this.scheduledExecutor = scheduledExecutor;
        return this;
    }

    public SlotManagerBuilder setTaskManagerRequestTimeout(Time taskManagerRequestTimeout) {
        this.taskManagerRequestTimeout = taskManagerRequestTimeout;
        return this;
    }

    public SlotManagerBuilder setSlotRequestTimeout(Time slotRequestTimeout) {
        this.slotRequestTimeout = slotRequestTimeout;
        return this;
    }

    public SlotManagerBuilder setTaskManagerTimeout(Time taskManagerTimeout) {
        this.taskManagerTimeout = taskManagerTimeout;
        return this;
    }

    public SlotManagerBuilder setWaitResultConsumedBeforeRelease(boolean waitResultConsumedBeforeRelease) {
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        return this;
    }

    public SlotManagerBuilder setSlotMatchingStrategy(SlotMatchingStrategy slotMatchingStrategy) {
        this.slotMatchingStrategy = slotMatchingStrategy;
        return this;
    }

    public SlotManagerBuilder setDefaultWorkerResourceSpec(WorkerResourceSpec defaultWorkerResourceSpec) {
        this.defaultWorkerResourceSpec = defaultWorkerResourceSpec;
        return this;
    }

    public SlotManagerBuilder setNumSlotsPerWorker(int numSlotsPerWorker) {
        this.numSlotsPerWorker = numSlotsPerWorker;
        return this;
    }

    public SlotManagerBuilder setSlotManagerMetricGroup(SlotManagerMetricGroup slotManagerMetricGroup) {
        this.slotManagerMetricGroup = slotManagerMetricGroup;
        return this;
    }

    public SlotManagerBuilder setMaxSlotNum(int maxSlotNum) {
        this.maxSlotNum = maxSlotNum;
        return this;
    }

    public SlotManagerBuilder setRedundantTaskManagerNum(int redundantTaskManagerNum) {
        this.redundantTaskManagerNum = redundantTaskManagerNum;
        return this;
    }

    public SlotManagerImpl build() {
        SlotManagerConfiguration slotManagerConfiguration = new SlotManagerConfiguration(this.taskManagerRequestTimeout, this.slotRequestTimeout, this.taskManagerTimeout, this.waitResultConsumedBeforeRelease, this.slotMatchingStrategy, this.defaultWorkerResourceSpec, this.numSlotsPerWorker, this.maxSlotNum, new CPUResource(Double.MAX_VALUE), MemorySize.MAX_VALUE, this.redundantTaskManagerNum);
        return new SlotManagerImpl(this.scheduledExecutor, slotManagerConfiguration, this.slotManagerMetricGroup);
    }

    public SlotManagerImpl buildAndStartWithDirectExec(ResourceManagerId resourceManagerId, ResourceActions resourceManagerActions) {
        SlotManagerImpl slotManager = this.build();
        slotManager.start(resourceManagerId, Executors.directExecutor(), resourceManagerActions);
        return slotManager;
    }
}

