/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.metrics;

import java.io.IOException;
import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class MetricStoreTest
extends TestLogger {
    @Test
    public void testAdd() throws IOException {
        MetricStore store = MetricStoreTest.setupStore(new MetricStore());
        Assert.assertEquals((Object)"0", (Object)store.getJobManagerMetricStore().getMetric("abc.metric1", "-1"));
        Assert.assertEquals((Object)"1", (Object)store.getTaskManagerMetricStore("tmid").getMetric("abc.metric2", "-1"));
        Assert.assertEquals((Object)"2", (Object)store.getJobMetricStore("jobid").getMetric("abc.metric3", "-1"));
        Assert.assertEquals((Object)"3", (Object)store.getJobMetricStore("jobid").getMetric("abc.metric4", "-1"));
        Assert.assertEquals((Object)"4", (Object)store.getTaskMetricStore("jobid", "taskid").getMetric("8.abc.metric5", "-1"));
        Assert.assertEquals((Object)"5", (Object)store.getTaskMetricStore("jobid", "taskid").getMetric("8.opname.abc.metric6", "-1"));
        Assert.assertEquals((Object)"6", (Object)store.getTaskMetricStore("jobid", "taskid").getMetric("8.opname.abc.metric7", "-1"));
    }

    @Test
    public void testMalformedNameHandling() {
        MetricStore store = new MetricStore();
        store.add(null);
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo("");
        MetricDump.CounterDump cd = new MetricDump.CounterDump((QueryScopeInfo)info, "", 0L);
        store.add((MetricDump)cd);
        Assert.assertEquals((long)0L, (long)store.getJobManager().metrics.size());
        Assert.assertEquals((long)0L, (long)store.getTaskManagers().size());
        Assert.assertEquals((long)0L, (long)store.getJobs().size());
    }

    public static MetricStore setupStore(MetricStore store) {
        QueryScopeInfo.JobManagerQueryScopeInfo jm = new QueryScopeInfo.JobManagerQueryScopeInfo("abc");
        MetricDump.CounterDump cd1 = new MetricDump.CounterDump((QueryScopeInfo)jm, "metric1", 0L);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid", "abc");
        MetricDump.CounterDump cd2 = new MetricDump.CounterDump((QueryScopeInfo)tm, "metric2", 1L);
        MetricDump.CounterDump cd2a = new MetricDump.CounterDump((QueryScopeInfo)tm, "metric22", 1L);
        QueryScopeInfo.TaskManagerQueryScopeInfo tm2 = new QueryScopeInfo.TaskManagerQueryScopeInfo("tmid2", "abc");
        MetricDump.CounterDump cd22 = new MetricDump.CounterDump((QueryScopeInfo)tm2, "metric2", 10L);
        MetricDump.CounterDump cd22a = new MetricDump.CounterDump((QueryScopeInfo)tm2, "metric2b", 10L);
        QueryScopeInfo.JobQueryScopeInfo job = new QueryScopeInfo.JobQueryScopeInfo("jobid", "abc");
        MetricDump.CounterDump cd3 = new MetricDump.CounterDump((QueryScopeInfo)job, "metric3", 2L);
        MetricDump.CounterDump cd4 = new MetricDump.CounterDump((QueryScopeInfo)job, "metric4", 3L);
        QueryScopeInfo.JobQueryScopeInfo job2 = new QueryScopeInfo.JobQueryScopeInfo("jobid2", "abc");
        MetricDump.CounterDump cd32 = new MetricDump.CounterDump((QueryScopeInfo)job2, "metric3", 2L);
        MetricDump.CounterDump cd42 = new MetricDump.CounterDump((QueryScopeInfo)job2, "metric4", 3L);
        QueryScopeInfo.TaskQueryScopeInfo task = new QueryScopeInfo.TaskQueryScopeInfo("jobid", "taskid", 8, "abc");
        MetricDump.CounterDump cd5 = new MetricDump.CounterDump((QueryScopeInfo)task, "metric5", 4L);
        QueryScopeInfo.OperatorQueryScopeInfo operator = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 8, "opname", "abc");
        MetricDump.CounterDump cd6 = new MetricDump.CounterDump((QueryScopeInfo)operator, "metric6", 5L);
        MetricDump.CounterDump cd7 = new MetricDump.CounterDump((QueryScopeInfo)operator, "metric7", 6L);
        QueryScopeInfo.OperatorQueryScopeInfo operator2 = new QueryScopeInfo.OperatorQueryScopeInfo("jobid", "taskid", 1, "opname", "abc");
        MetricDump.CounterDump cd62 = new MetricDump.CounterDump((QueryScopeInfo)operator2, "metric6", 5L);
        MetricDump.CounterDump cd72 = new MetricDump.CounterDump((QueryScopeInfo)operator2, "metric7", 6L);
        store.add((MetricDump)cd1);
        store.add((MetricDump)cd2);
        store.add((MetricDump)cd2a);
        store.add((MetricDump)cd3);
        store.add((MetricDump)cd4);
        store.add((MetricDump)cd5);
        store.add((MetricDump)cd6);
        store.add((MetricDump)cd7);
        store.add((MetricDump)cd62);
        store.add((MetricDump)cd72);
        store.add((MetricDump)cd22);
        store.add((MetricDump)cd22a);
        store.add((MetricDump)cd32);
        store.add((MetricDump)cd42);
        return store;
    }
}

