/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class RestResponseMarshallingTestBase<R extends ResponseBody>
extends TestLogger {
    protected abstract Class<R> getTestResponseClass();

    protected Collection<Class<?>> getTypeParameters() {
        return Collections.emptyList();
    }

    protected abstract R getTestResponseInstance() throws Exception;

    @Test
    public void testJsonMarshalling() throws Exception {
        R expected = this.getTestResponseInstance();
        ObjectMapper objectMapper = RestMapperUtils.getStrictObjectMapper();
        String marshalled = objectMapper.writeValueAsString(expected);
        Collection<Class<?>> typeParameters = this.getTypeParameters();
        JavaType type = typeParameters.isEmpty() ? objectMapper.getTypeFactory().constructType(this.getTestResponseClass()) : objectMapper.getTypeFactory().constructParametricType(this.getTestResponseClass(), typeParameters.toArray(new Class[typeParameters.size()]));
        ResponseBody unmarshalled = (ResponseBody)objectMapper.readValue(marshalled, type);
        this.assertOriginalEqualsToUnmarshalled(expected, unmarshalled);
    }

    protected void assertOriginalEqualsToUnmarshalled(R expected, R actual) {
        Assert.assertEquals(expected, actual);
    }
}

