/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Collection;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.scheduler.AvailableInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.InputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.TestingInputsLocationsRetriever;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class AvailableInputsLocationsRetrieverTest
extends TestLogger {
    private static final ExecutionVertexID EV1 = ExecutionGraphTestUtils.createRandomExecutionVertexId();
    private static final ExecutionVertexID EV2 = ExecutionGraphTestUtils.createRandomExecutionVertexId();

    @Test
    public void testNoInputLocation() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assert.assertThat((Object)availableInputsLocationsRetriever.getTaskManagerLocation(EV1).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNoInputLocationIfNotDone() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.markScheduled(EV1);
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assert.assertThat((Object)availableInputsLocationsRetriever.getTaskManagerLocation(EV1).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testNoInputLocationIfFailed() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.failTaskManagerLocation(EV1, new Throwable());
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assert.assertThat((Object)availableInputsLocationsRetriever.getTaskManagerLocation(EV1).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testInputLocationIfDone() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        originalLocationRetriever.assignTaskManagerLocation(EV1);
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Assert.assertThat((Object)availableInputsLocationsRetriever.getTaskManagerLocation(EV1).isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testConsumedResultPartitionsProducers() {
        TestingInputsLocationsRetriever originalLocationRetriever = AvailableInputsLocationsRetrieverTest.getOriginalLocationRetriever();
        AvailableInputsLocationsRetriever availableInputsLocationsRetriever = new AvailableInputsLocationsRetriever((InputsLocationsRetriever)originalLocationRetriever);
        Collection producers = availableInputsLocationsRetriever.getConsumedResultPartitionsProducers(EV2);
        Assert.assertThat((Object)producers.size(), (Matcher)Is.is((Object)1));
        Collection resultProducers = (Collection)producers.iterator().next();
        Assert.assertThat((Object)resultProducers, (Matcher)Matchers.contains((Object[])new ExecutionVertexID[]{EV1}));
    }

    private static TestingInputsLocationsRetriever getOriginalLocationRetriever() {
        return new TestingInputsLocationsRetriever.Builder().connectConsumerToProducer(EV2, EV1).build();
    }
}

