/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingResultPartition;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.Preconditions;

public class TestingSchedulingResultPartition
implements SchedulingResultPartition {
    private final IntermediateDataSetID intermediateDataSetID;
    private final IntermediateResultPartitionID intermediateResultPartitionID;
    private final ResultPartitionType partitionType;
    private TestingSchedulingExecutionVertex producer;
    private final List<ConsumerVertexGroup> consumerVertexGroups;
    private final Map<ExecutionVertexID, TestingSchedulingExecutionVertex> executionVerticesById;
    private ResultPartitionState state;

    private TestingSchedulingResultPartition(IntermediateDataSetID dataSetID, int partitionNum, ResultPartitionType type, ResultPartitionState state) {
        this.intermediateDataSetID = dataSetID;
        this.partitionType = type;
        this.state = state;
        this.intermediateResultPartitionID = new IntermediateResultPartitionID(dataSetID, partitionNum);
        this.consumerVertexGroups = new ArrayList<ConsumerVertexGroup>();
        this.executionVerticesById = new HashMap<ExecutionVertexID, TestingSchedulingExecutionVertex>();
    }

    public IntermediateResultPartitionID getId() {
        return this.intermediateResultPartitionID;
    }

    public IntermediateDataSetID getResultId() {
        return this.intermediateDataSetID;
    }

    public ResultPartitionType getResultType() {
        return this.partitionType;
    }

    public ResultPartitionState getState() {
        return this.state;
    }

    public TestingSchedulingExecutionVertex getProducer() {
        return this.producer;
    }

    public Iterable<TestingSchedulingExecutionVertex> getConsumers() {
        return IterableUtils.flatMap(this.consumerVertexGroups, this.executionVerticesById::get);
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.consumerVertexGroups;
    }

    void addConsumer(TestingSchedulingExecutionVertex consumer) {
        this.consumerVertexGroups.add(ConsumerVertexGroup.fromSingleVertex((ExecutionVertexID)consumer.getId()));
        this.executionVerticesById.putIfAbsent(consumer.getId(), consumer);
    }

    void addConsumerGroup(ConsumerVertexGroup consumerVertexGroup, Map<ExecutionVertexID, TestingSchedulingExecutionVertex> consumerVertexById) {
        this.consumerVertexGroups.add(consumerVertexGroup);
        this.executionVerticesById.putAll(consumerVertexById);
    }

    void setProducer(TestingSchedulingExecutionVertex producer) {
        this.producer = (TestingSchedulingExecutionVertex)Preconditions.checkNotNull((Object)producer);
    }

    void setState(ResultPartitionState state) {
        this.state = state;
    }

    public static final class Builder {
        private IntermediateDataSetID intermediateDataSetId = new IntermediateDataSetID();
        private int partitionNum = 0;
        private ResultPartitionType resultPartitionType = ResultPartitionType.BLOCKING;
        private ResultPartitionState resultPartitionState = ResultPartitionState.CONSUMABLE;

        Builder withIntermediateDataSetID(IntermediateDataSetID intermediateDataSetId) {
            this.intermediateDataSetId = intermediateDataSetId;
            return this;
        }

        Builder withResultPartitionState(ResultPartitionState state) {
            this.resultPartitionState = state;
            return this;
        }

        Builder withResultPartitionType(ResultPartitionType type) {
            this.resultPartitionType = type;
            return this;
        }

        Builder withPartitionNum(int partitionNum) {
            this.partitionNum = partitionNum;
            return this;
        }

        TestingSchedulingResultPartition build() {
            return new TestingSchedulingResultPartition(this.intermediateDataSetId, this.partitionNum, this.resultPartitionType, this.resultPartitionState);
        }
    }
}

