/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.source.coordinator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.mocks.MockSourceSplit;
import org.apache.flink.api.connector.source.mocks.MockSourceSplitSerializer;
import org.apache.flink.api.connector.source.mocks.MockSplitEnumeratorCheckpointSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.EventReceivingTasks;
import org.apache.flink.runtime.operators.coordination.MockOperatorCoordinatorContext;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.source.coordinator.SourceCoordinator;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorContext;
import org.apache.flink.runtime.source.coordinator.SourceCoordinatorProvider;
import org.apache.flink.runtime.source.coordinator.SplitAssignmentTracker;
import org.apache.flink.runtime.source.coordinator.TestingSplitEnumerator;
import org.apache.flink.runtime.source.event.ReaderRegistrationEvent;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.util.ExceptionUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class SourceCoordinatorTestBase {
    protected static final String OPERATOR_NAME = "TestOperator";
    protected static final OperatorID TEST_OPERATOR_ID = new OperatorID(1234L, 5678L);
    protected static final int NUM_SUBTASKS = 3;
    protected EventReceivingTasks receivingTasks;
    protected MockOperatorCoordinatorContext operatorCoordinatorContext;
    protected SourceCoordinatorProvider.CoordinatorExecutorThreadFactory coordinatorThreadFactory;
    protected ExecutorService coordinatorExecutor;
    protected SplitAssignmentTracker<MockSourceSplit> splitSplitAssignmentTracker;
    protected SourceCoordinatorContext<MockSourceSplit> context;
    protected SourceCoordinator<MockSourceSplit, Set<MockSourceSplit>> sourceCoordinator;
    private TestingSplitEnumerator<MockSourceSplit> enumerator;

    @Before
    public void setup() throws Exception {
        this.receivingTasks = EventReceivingTasks.createForRunningTasks();
        this.operatorCoordinatorContext = new MockOperatorCoordinatorContext(TEST_OPERATOR_ID, 3);
        this.splitSplitAssignmentTracker = new SplitAssignmentTracker();
        String coordinatorThreadName = TEST_OPERATOR_ID.toHexString();
        this.coordinatorThreadFactory = new SourceCoordinatorProvider.CoordinatorExecutorThreadFactory(coordinatorThreadName, this.getClass().getClassLoader());
        this.coordinatorExecutor = Executors.newSingleThreadExecutor((ThreadFactory)this.coordinatorThreadFactory);
        this.sourceCoordinator = this.getNewSourceCoordinator();
        this.context = this.sourceCoordinator.getContext();
    }

    @After
    public void cleanUp() throws InterruptedException, TimeoutException {
        this.coordinatorExecutor.shutdown();
        if (!this.coordinatorExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new TimeoutException("Failed to close the CoordinatorExecutor before timeout.");
        }
    }

    protected TestingSplitEnumerator<MockSourceSplit> getEnumerator() {
        if (this.enumerator == null) {
            this.enumerator = (TestingSplitEnumerator)this.sourceCoordinator.getEnumerator();
            Assert.assertNotNull((String)"source was not started", this.enumerator);
        }
        return this.enumerator;
    }

    protected void sourceReady() throws Exception {
        this.sourceCoordinator.start();
        this.setAllReaderTasksReady(this.sourceCoordinator);
    }

    protected void setAllReaderTasksReady() {
        this.setAllReaderTasksReady(this.sourceCoordinator);
    }

    protected void setAllReaderTasksReady(SourceCoordinator<?, ?> sourceCoordinator) {
        for (int i = 0; i < 3; ++i) {
            sourceCoordinator.subtaskReady(i, this.receivingTasks.createGatewayForSubtask(i));
        }
    }

    protected void addTestingSplitSet(int num) {
        ArrayList<MockSourceSplit> splits = new ArrayList<MockSourceSplit>();
        for (int i = 0; i < num; ++i) {
            splits.add(new MockSourceSplit(i));
        }
        this.getEnumerator().addNewSplits((Collection<MockSourceSplit>)splits);
    }

    protected void registerReader(int subtask) {
        this.sourceCoordinator.handleEventFromOperator(subtask, (OperatorEvent)new ReaderRegistrationEvent(subtask, "location_" + subtask));
    }

    protected void waitForCoordinatorToProcessActions() {
        CompletableFuture future = new CompletableFuture();
        this.context.runInCoordinatorThread(() -> future.complete(null));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)"test interrupted");
        }
        catch (ExecutionException e) {
            ExceptionUtils.rethrow((Throwable)ExceptionUtils.stripExecutionException((Throwable)e));
        }
    }

    protected SourceCoordinator<MockSourceSplit, Set<MockSourceSplit>> getNewSourceCoordinator() {
        Source mockSource = TestingSplitEnumerator.factorySource(new MockSourceSplitSerializer(), new MockSplitEnumeratorCheckpointSerializer());
        return new SourceCoordinator(OPERATOR_NAME, this.coordinatorExecutor, mockSource, this.getNewSourceCoordinatorContext());
    }

    protected SourceCoordinatorContext<MockSourceSplit> getNewSourceCoordinatorContext() {
        return new SourceCoordinatorContext(this.coordinatorExecutor, Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory(this.coordinatorThreadFactory.getCoordinatorThreadName() + "-worker")), this.coordinatorThreadFactory, (OperatorCoordinator.Context)this.operatorCoordinatorContext, (SimpleVersionedSerializer)new MockSourceSplitSerializer(), this.splitSplitAssignmentTracker);
    }
}

