/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.runtime.state.JavaSerializer;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaSerializerTest
extends SerializerTestBase<Serializable> {
    private static final ClassLoaderUtils.ObjectAndClassLoader<Serializable> OUTSIDE_CLASS_LOADING = ClassLoaderUtils.createSerializableObjectFromNewClassLoader();
    private ClassLoader originalClassLoader;

    @Before
    public void setupClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(OUTSIDE_CLASS_LOADING.getClassLoader());
    }

    @After
    public void restoreOriginalClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    public void guardTest() {
        try {
            Class.forName(((Serializable)OUTSIDE_CLASS_LOADING.getObject()).getClass().getName());
            Assert.fail((String)"Test ineffective: The test class that should not be on the classpath is actually on the classpath.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected TypeSerializer<Serializable> createSerializer() {
        Thread.currentThread().setContextClassLoader(OUTSIDE_CLASS_LOADING.getClassLoader());
        return new JavaSerializer();
    }

    protected int getLength() {
        return -1;
    }

    protected Class<Serializable> getTypeClass() {
        return Serializable.class;
    }

    protected Serializable[] getTestData() {
        return new Serializable[]{new Integer(42), new File("/some/path/that/I/made/up"), (Serializable)OUTSIDE_CLASS_LOADING.getObject(), new Tuple1(OUTSIDE_CLASS_LOADING.getObject())};
    }

    public void testInstantiate() {
    }
}

