/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Arrays;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.junit.Assert;
import org.junit.Test;

public class KeyGroupRangeOffsetTest {
    @Test
    public void testKeyGroupIntersection() {
        long[] offsets = new long[9];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i;
        }
        int startKeyGroup = 2;
        KeyGroupRangeOffsets keyGroupRangeOffsets = new KeyGroupRangeOffsets(KeyGroupRange.of((int)startKeyGroup, (int)10), offsets);
        KeyGroupRangeOffsets intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)3, (int)7));
        KeyGroupRangeOffsets expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)3, (int)7), Arrays.copyOfRange(offsets, 3 - startKeyGroup, 8 - startKeyGroup));
        Assert.assertEquals((Object)expected, (Object)intersection);
        Assert.assertEquals((Object)keyGroupRangeOffsets, (Object)keyGroupRangeOffsets.getIntersection(keyGroupRangeOffsets.getKeyGroupRange()));
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)11, (int)13));
        Assert.assertEquals((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE, (Object)intersection.getKeyGroupRange());
        Assert.assertFalse((boolean)intersection.iterator().hasNext());
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)5, (int)13));
        expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)5, (int)10), Arrays.copyOfRange(offsets, 5 - startKeyGroup, 11 - startKeyGroup));
        Assert.assertEquals((Object)expected, (Object)intersection);
        intersection = keyGroupRangeOffsets.getIntersection(KeyGroupRange.of((int)0, (int)2));
        expected = new KeyGroupRangeOffsets(KeyGroupRange.of((int)2, (int)2), Arrays.copyOfRange(offsets, 2 - startKeyGroup, 3 - startKeyGroup));
        Assert.assertEquals((Object)intersection, (Object)intersection);
    }

    @Test
    public void testKeyGroupRangeOffsetsBasics() {
        int i;
        this.testKeyGroupRangeOffsetsBasicsInternal(0, 0);
        this.testKeyGroupRangeOffsetsBasicsInternal(0, 1);
        this.testKeyGroupRangeOffsetsBasicsInternal(1, 2);
        this.testKeyGroupRangeOffsetsBasicsInternal(42, 42);
        this.testKeyGroupRangeOffsetsBasicsInternal(3, 7);
        this.testKeyGroupRangeOffsetsBasicsInternal(0, Short.MAX_VALUE);
        this.testKeyGroupRangeOffsetsBasicsInternal(32766, Short.MAX_VALUE);
        try {
            this.testKeyGroupRangeOffsetsBasicsInternal(-3, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        KeyGroupRangeOffsets testNoGivenOffsets = new KeyGroupRangeOffsets(3, 7);
        for (i = 3; i <= 7; ++i) {
            testNoGivenOffsets.setKeyGroupOffset(i, (long)(i + 1));
        }
        for (i = 3; i <= 7; ++i) {
            Assert.assertEquals((long)(i + 1), (long)testNoGivenOffsets.getKeyGroupOffset(i));
        }
    }

    private void testKeyGroupRangeOffsetsBasicsInternal(int startKeyGroup, int endKeyGroup) {
        long[] offsets = new long[endKeyGroup - startKeyGroup + 1];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = i;
        }
        KeyGroupRangeOffsets keyGroupRange = new KeyGroupRangeOffsets(startKeyGroup, endKeyGroup, offsets);
        KeyGroupRangeOffsets sameButDifferentConstr = new KeyGroupRangeOffsets(KeyGroupRange.of((int)startKeyGroup, (int)endKeyGroup), offsets);
        Assert.assertEquals((Object)keyGroupRange, (Object)sameButDifferentConstr);
        int numberOfKeyGroup = keyGroupRange.getKeyGroupRange().getNumberOfKeyGroups();
        Assert.assertEquals((long)Math.max(0, endKeyGroup - startKeyGroup + 1), (long)numberOfKeyGroup);
        if (numberOfKeyGroup > 0) {
            int i;
            Assert.assertEquals((long)startKeyGroup, (long)keyGroupRange.getKeyGroupRange().getStartKeyGroup());
            Assert.assertEquals((long)endKeyGroup, (long)keyGroupRange.getKeyGroupRange().getEndKeyGroup());
            int c = startKeyGroup;
            for (Tuple2 tuple : keyGroupRange) {
                Assert.assertEquals((long)c, (long)((Integer)tuple.f0).intValue());
                Assert.assertTrue((boolean)keyGroupRange.getKeyGroupRange().contains(((Integer)tuple.f0).intValue()));
                Assert.assertEquals((long)((long)c - (long)startKeyGroup), (long)((Long)tuple.f1));
                ++c;
            }
            for (int i2 = startKeyGroup; i2 <= endKeyGroup; ++i2) {
                Assert.assertEquals((long)(i2 - startKeyGroup), (long)keyGroupRange.getKeyGroupOffset(i2));
            }
            int newOffset = 42;
            for (i = startKeyGroup; i <= endKeyGroup; ++i) {
                keyGroupRange.setKeyGroupOffset(i, (long)newOffset);
                ++newOffset;
            }
            for (i = startKeyGroup; i <= endKeyGroup; ++i) {
                Assert.assertEquals((long)(42 + i - startKeyGroup), (long)keyGroupRange.getKeyGroupOffset(i));
            }
            Assert.assertEquals((long)(endKeyGroup + 1), (long)c);
            Assert.assertFalse((boolean)keyGroupRange.getKeyGroupRange().contains(startKeyGroup - 1));
            Assert.assertFalse((boolean)keyGroupRange.getKeyGroupRange().contains(endKeyGroup + 1));
        } else {
            Assert.assertEquals((Object)KeyGroupRange.EMPTY_KEY_GROUP_RANGE, (Object)keyGroupRange);
        }
    }
}

