/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProviderImpl;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalRecoveryDirectoryProviderImplTest
extends TestLogger {
    private static final JobID JOB_ID = new JobID();
    private static final JobVertexID JOB_VERTEX_ID = new JobVertexID();
    private static final int SUBTASK_INDEX = 0;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();
    private LocalRecoveryDirectoryProviderImpl directoryProvider;
    private File[] allocBaseFolders;

    @Before
    public void setup() throws IOException {
        this.allocBaseFolders = new File[]{this.tmpFolder.newFolder(), this.tmpFolder.newFolder(), this.tmpFolder.newFolder()};
        this.directoryProvider = new LocalRecoveryDirectoryProviderImpl(this.allocBaseFolders, JOB_ID, JOB_VERTEX_ID, 0);
    }

    @Test
    public void allocationBaseDir() {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)this.allocBaseFolders[i % this.allocBaseFolders.length], (Object)this.directoryProvider.allocationBaseDirectory((long)i));
        }
    }

    @Test
    public void selectAllocationBaseDir() {
        for (int i = 0; i < this.allocBaseFolders.length; ++i) {
            Assert.assertEquals((Object)this.allocBaseFolders[i], (Object)this.directoryProvider.selectAllocationBaseDirectory(i));
        }
    }

    @Test
    public void allocationBaseDirectoriesCount() {
        Assert.assertEquals((long)this.allocBaseFolders.length, (long)this.directoryProvider.allocationBaseDirsCount());
    }

    @Test
    public void subtaskSpecificDirectory() {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)new File(this.directoryProvider.allocationBaseDirectory((long)i), this.directoryProvider.subtaskDirString()), (Object)this.directoryProvider.subtaskBaseDirectory((long)i));
        }
    }

    @Test
    public void subtaskCheckpointSpecificDirectory() {
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)new File(this.directoryProvider.subtaskBaseDirectory((long)i), this.directoryProvider.checkpointDirString((long)i)), (Object)this.directoryProvider.subtaskSpecificCheckpointDirectory((long)i));
        }
    }

    @Test
    public void testPathStringConstants() {
        Assert.assertEquals((Object)this.directoryProvider.subtaskDirString(), (Object)("jid_" + JOB_ID + "/" + "vtx_" + JOB_VERTEX_ID + "_sti_" + 0));
        long checkpointId = 42L;
        Assert.assertEquals((Object)this.directoryProvider.checkpointDirString(42L), (Object)"chk_42");
    }

    @Test
    public void testPreconditionsNotNullFiles() {
        try {
            new LocalRecoveryDirectoryProviderImpl(new File[]{null}, JOB_ID, JOB_VERTEX_ID, 0);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

