/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SnapshotResultTest
extends TestLogger {
    @Test
    public void discardState() throws Exception {
        SnapshotResult result = SnapshotResult.withLocalState((StateObject)((StateObject)Mockito.mock(StateObject.class)), (StateObject)((StateObject)Mockito.mock(StateObject.class)));
        result.discardState();
        ((StateObject)Mockito.verify((Object)result.getJobManagerOwnedSnapshot())).discardState();
        ((StateObject)Mockito.verify((Object)result.getTaskLocalSnapshot())).discardState();
    }

    @Test
    public void getStateSize() {
        long size = 42L;
        SnapshotResult result = SnapshotResult.withLocalState((StateObject)new DummyStateObject(size), (StateObject)new DummyStateObject(size));
        Assert.assertEquals((long)size, (long)result.getStateSize());
    }

    static class DummyStateObject
    implements StateObject {
        private static final long serialVersionUID = 1L;
        private final long size;

        DummyStateObject(long size) {
            this.size = size;
        }

        public void discardState() {
        }

        public long getStateSize() {
            return this.size;
        }
    }
}

