/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.state.changelog.StateChangelogWriterFactory;
import org.apache.flink.runtime.state.changelog.StateChangelogWriterFactoryLoader;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryStateChangelogWriterFactory;
import org.apache.flink.shaded.curator4.com.google.common.collect.ImmutableList;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class StateChangelogWriterFactoryLoaderTest {
    @Test
    public void testLoadSpiImplementation() {
        Assert.assertTrue((boolean)new StateChangelogWriterFactoryLoader(this.getPluginManager(Collections.emptyIterator())).load().hasNext());
    }

    @Test
    public void testLoadPluginImplementation() {
        InMemoryStateChangelogWriterFactory impl = new InMemoryStateChangelogWriterFactory();
        PluginManager pluginManager = this.getPluginManager(Collections.singletonList(impl).iterator());
        Iterator loaded = new StateChangelogWriterFactoryLoader(pluginManager).load();
        Assert.assertTrue((boolean)ImmutableList.copyOf((Iterator)loaded).contains((Object)impl));
    }

    private PluginManager getPluginManager(final Iterator<? extends StateChangelogWriterFactory<?>> iterator) {
        return new PluginManager(){

            public <P> Iterator<P> load(Class<P> service) {
                Preconditions.checkArgument((boolean)service.equals(StateChangelogWriterFactory.class));
                return iterator;
            }
        };
    }
}

