/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.ttl;

import org.apache.flink.runtime.state.ttl.TtlValue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class TtlValueMatchers {
    public static <T> Matcher<TtlValue<T>> ttlValue(Matcher<T> valueMatcher, Matcher<Long> timestampMatcher) {
        return new IsTtlValue<T>(valueMatcher, timestampMatcher);
    }

    static class IsTtlValue<T>
    extends TypeSafeDiagnosingMatcher<TtlValue<T>> {
        private final Matcher<T> valueMatcher;
        private final Matcher<Long> timestampMatcher;

        public IsTtlValue(Matcher<T> valueMatcher, Matcher<Long> timestampMatcher) {
            this.valueMatcher = valueMatcher;
            this.timestampMatcher = timestampMatcher;
        }

        protected boolean matchesSafely(TtlValue<T> item, Description mismatchDescription) {
            mismatchDescription.appendText("TtlValue with value ");
            mismatchDescription.appendValue(item.getUserValue());
            mismatchDescription.appendText(" with timestamp ");
            mismatchDescription.appendValue((Object)item.getLastAccessTimestamp());
            return this.valueMatcher.matches(item.getUserValue()) && this.timestampMatcher.matches((Object)item.getLastAccessTimestamp());
        }

        public void describeTo(Description description) {
            description.appendText("TtlValue with value ");
            this.valueMatcher.describeTo(description);
            description.appendText(" with timestamp ");
            this.timestampMatcher.describeTo(description);
        }
    }
}

