/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testtasks;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;

public class OnceBlockingNoOpInvokable
extends AbstractInvokable {
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private static volatile CountDownLatch numOpsPending = new CountDownLatch(1);
    private static volatile boolean isBlocking = true;
    private final Object lock = new Object();
    private volatile boolean running = true;

    public OnceBlockingNoOpInvokable(Environment environment) {
        super(environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() throws Exception {
        instanceCount.incrementAndGet();
        numOpsPending.countDown();
        Object object = this.lock;
        synchronized (object) {
            while (isBlocking && this.running) {
                this.lock.wait();
            }
        }
        isBlocking = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> cancel() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
        return CompletableFuture.completedFuture(null);
    }

    public static void waitUntilOpsAreRunning() throws InterruptedException {
        numOpsPending.await();
    }

    public static int getInstanceCount() {
        return instanceCount.get();
    }

    public static void resetInstanceCount() {
        instanceCount.set(0);
    }

    public static void resetFor(int parallelism) {
        numOpsPending = new CountDownLatch(parallelism);
        isBlocking = true;
    }
}

