/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.File;
import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.Preconditions;

public class TestingTaskManagerRuntimeInfo
implements TaskManagerRuntimeInfo {
    private final Configuration configuration;
    private final String[] tmpDirectories;
    private final String taskManagerExternalAddress;

    public TestingTaskManagerRuntimeInfo() {
        this(new Configuration(), System.getProperty("java.io.tmpdir").split(",|" + File.pathSeparator));
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration) {
        this(configuration, EnvironmentInformation.getTemporaryFileDirectory());
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String tmpDirectory) {
        this(configuration, new String[]{(String)Preconditions.checkNotNull((Object)tmpDirectory)});
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String[] tmpDirectories) {
        this(configuration, tmpDirectories, InetAddress.getLoopbackAddress().getHostAddress());
    }

    public TestingTaskManagerRuntimeInfo(Configuration configuration, String[] tmpDirectories, String taskManagerExternalAddress) {
        this.configuration = configuration;
        this.tmpDirectories = tmpDirectories;
        this.taskManagerExternalAddress = taskManagerExternalAddress;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String[] getTmpDirectories() {
        return this.tmpDirectories;
    }

    public boolean shouldExitJvmOnOutOfMemoryError() {
        return false;
    }

    public String getTaskManagerExternalAddress() {
        return this.taskManagerExternalAddress;
    }
}

