/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.JobsOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.TriFunction;

public class TestingRestfulGateway
implements RestfulGateway {
    static final Function<JobID, CompletableFuture<Acknowledge>> DEFAULT_CANCEL_JOB_FUNCTION = jobId -> CompletableFuture.completedFuture(Acknowledge.get());
    static final Function<JobID, CompletableFuture<JobResult>> DEFAULT_REQUEST_JOB_RESULT_FUNCTION = jobId -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final Function<JobID, CompletableFuture<ArchivedExecutionGraph>> DEFAULT_REQUEST_JOB_FUNCTION = jobId -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final Function<JobID, CompletableFuture<ExecutionGraphInfo>> DEFAULT_REQUEST_EXECUTION_GRAPH_INFO = jobId -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final Function<JobID, CompletableFuture<JobStatus>> DEFAULT_REQUEST_JOB_STATUS_FUNCTION = jobId -> CompletableFuture.completedFuture(JobStatus.RUNNING);
    static final Supplier<CompletableFuture<MultipleJobsDetails>> DEFAULT_REQUEST_MULTIPLE_JOB_DETAILS_SUPPLIER = () -> CompletableFuture.completedFuture(new MultipleJobsDetails(Collections.emptyList()));
    static final Supplier<CompletableFuture<ClusterOverview>> DEFAULT_REQUEST_CLUSTER_OVERVIEW_SUPPLIER = () -> CompletableFuture.completedFuture(new ClusterOverview(0, 0, 0, 0, 0, 0, 0));
    static final Supplier<CompletableFuture<Collection<String>>> DEFAULT_REQUEST_METRIC_QUERY_SERVICE_PATHS_SUPPLIER = () -> CompletableFuture.completedFuture(Collections.emptyList());
    static final Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> DEFAULT_REQUEST_TASK_MANAGER_METRIC_QUERY_SERVICE_PATHS_SUPPLIER = () -> CompletableFuture.completedFuture(Collections.emptyList());
    static final Supplier<CompletableFuture<Acknowledge>> DEFAULT_CLUSTER_SHUTDOWN_SUPPLIER = () -> CompletableFuture.completedFuture(Acknowledge.get());
    static final BiFunction<JobID, String, CompletableFuture<String>> DEFAULT_TRIGGER_SAVEPOINT_FUNCTION = (jobId, targetDirectory) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final BiFunction<JobID, String, CompletableFuture<String>> DEFAULT_STOP_WITH_SAVEPOINT_FUNCTION = (jobId, targetDirectory) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> DEFAULT_DELIVER_COORDINATION_REQUEST_TO_COORDINATOR_FUNCTION = (jobId, operatorId, serializedRequest) -> FutureUtils.completedExceptionally((Throwable)new UnsupportedOperationException());
    static final String LOCALHOST = "localhost";
    protected String address;
    protected String hostname;
    protected String restAddress;
    protected Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction;
    protected Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier;
    protected Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction;
    protected Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction;
    protected Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction;
    protected Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction;
    protected Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier;
    protected Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier;
    protected Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceAddressesSupplier;
    protected Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceAddressesSupplier;
    protected BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction;
    protected BiFunction<JobID, String, CompletableFuture<String>> stopWithSavepointFunction;
    protected TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction;

    public TestingRestfulGateway() {
        this(LOCALHOST, LOCALHOST, DEFAULT_CANCEL_JOB_FUNCTION, DEFAULT_REQUEST_JOB_FUNCTION, DEFAULT_REQUEST_EXECUTION_GRAPH_INFO, DEFAULT_REQUEST_JOB_RESULT_FUNCTION, DEFAULT_REQUEST_JOB_STATUS_FUNCTION, DEFAULT_REQUEST_MULTIPLE_JOB_DETAILS_SUPPLIER, DEFAULT_REQUEST_CLUSTER_OVERVIEW_SUPPLIER, DEFAULT_REQUEST_METRIC_QUERY_SERVICE_PATHS_SUPPLIER, DEFAULT_REQUEST_TASK_MANAGER_METRIC_QUERY_SERVICE_PATHS_SUPPLIER, DEFAULT_TRIGGER_SAVEPOINT_FUNCTION, DEFAULT_STOP_WITH_SAVEPOINT_FUNCTION, DEFAULT_CLUSTER_SHUTDOWN_SUPPLIER, DEFAULT_DELIVER_COORDINATION_REQUEST_TO_COORDINATOR_FUNCTION);
    }

    public TestingRestfulGateway(String address, String hostname, Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction, Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction, Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction, Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction, Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier, Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier, Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceAddressesSupplier, Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceAddressesSupplier, BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction, BiFunction<JobID, String, CompletableFuture<String>> stopWithSavepointFunction, Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier, TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction) {
        this.address = address;
        this.hostname = hostname;
        this.cancelJobFunction = cancelJobFunction;
        this.requestJobFunction = requestJobFunction;
        this.requestExecutionGraphInfoFunction = requestExecutionGraphInfoFunction;
        this.requestJobResultFunction = requestJobResultFunction;
        this.requestJobStatusFunction = requestJobStatusFunction;
        this.requestMultipleJobDetailsSupplier = requestMultipleJobDetailsSupplier;
        this.requestClusterOverviewSupplier = requestClusterOverviewSupplier;
        this.requestMetricQueryServiceAddressesSupplier = requestMetricQueryServiceAddressesSupplier;
        this.requestTaskManagerMetricQueryServiceAddressesSupplier = requestTaskManagerMetricQueryServiceAddressesSupplier;
        this.triggerSavepointFunction = triggerSavepointFunction;
        this.stopWithSavepointFunction = stopWithSavepointFunction;
        this.clusterShutdownSupplier = clusterShutdownSupplier;
        this.deliverCoordinationRequestToCoordinatorFunction = deliverCoordinationRequestToCoordinatorFunction;
    }

    public CompletableFuture<Acknowledge> cancelJob(JobID jobId, Time timeout) {
        return this.cancelJobFunction.apply(jobId);
    }

    public CompletableFuture<Acknowledge> shutDownCluster() {
        return this.clusterShutdownSupplier.get();
    }

    public CompletableFuture<ArchivedExecutionGraph> requestJob(JobID jobId, Time timeout) {
        return this.requestJobFunction.apply(jobId);
    }

    public CompletableFuture<ExecutionGraphInfo> requestExecutionGraphInfo(JobID jobId, Time timeout) {
        return this.requestExecutionGraphInfoFunction.apply(jobId);
    }

    public CompletableFuture<JobResult> requestJobResult(JobID jobId, Time timeout) {
        return this.requestJobResultFunction.apply(jobId);
    }

    public CompletableFuture<JobStatus> requestJobStatus(JobID jobId, Time timeout) {
        return this.requestJobStatusFunction.apply(jobId);
    }

    public CompletableFuture<MultipleJobsDetails> requestMultipleJobDetails(Time timeout) {
        return this.requestMultipleJobDetailsSupplier.get();
    }

    public CompletableFuture<ClusterOverview> requestClusterOverview(Time timeout) {
        return this.requestClusterOverviewSupplier.get();
    }

    public CompletableFuture<Collection<String>> requestMetricQueryServiceAddresses(Time timeout) {
        return this.requestMetricQueryServiceAddressesSupplier.get();
    }

    public CompletableFuture<Collection<Tuple2<ResourceID, String>>> requestTaskManagerMetricQueryServiceAddresses(Time timeout) {
        return this.requestTaskManagerMetricQueryServiceAddressesSupplier.get();
    }

    public CompletableFuture<String> triggerSavepoint(JobID jobId, String targetDirectory, boolean cancelJob, Time timeout) {
        return this.triggerSavepointFunction.apply(jobId, targetDirectory);
    }

    public CompletableFuture<String> stopWithSavepoint(JobID jobId, String targetDirectory, boolean terminate, Time timeout) {
        return this.stopWithSavepointFunction.apply(jobId, targetDirectory);
    }

    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(JobID jobId, OperatorID operatorId, SerializedValue<CoordinationRequest> serializedRequest, Time timeout) {
        return (CompletableFuture)this.deliverCoordinationRequestToCoordinatorFunction.apply((Object)jobId, (Object)operatorId, serializedRequest);
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TestingRestfulGateway build() {
            return new TestingRestfulGateway(this.address, this.hostname, this.cancelJobFunction, this.requestJobFunction, this.requestExecutionGraphInfoFunction, this.requestJobResultFunction, this.requestJobStatusFunction, this.requestMultipleJobDetailsSupplier, this.requestClusterOverviewSupplier, this.requestMetricQueryServiceGatewaysSupplier, this.requestTaskManagerMetricQueryServiceGatewaysSupplier, this.triggerSavepointFunction, this.stopWithSavepointFunction, this.clusterShutdownSupplier, (TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>>)this.deliverCoordinationRequestToCoordinatorFunction);
        }
    }

    protected static abstract class AbstractBuilder<T extends AbstractBuilder> {
        protected String address = "localhost";
        protected String hostname = "localhost";
        protected Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction = DEFAULT_CANCEL_JOB_FUNCTION;
        protected Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction = DEFAULT_REQUEST_JOB_FUNCTION;
        protected Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction = DEFAULT_REQUEST_EXECUTION_GRAPH_INFO;
        protected Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction = DEFAULT_REQUEST_JOB_RESULT_FUNCTION;
        protected Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction = DEFAULT_REQUEST_JOB_STATUS_FUNCTION;
        protected Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier = DEFAULT_REQUEST_MULTIPLE_JOB_DETAILS_SUPPLIER;
        protected Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier = DEFAULT_REQUEST_CLUSTER_OVERVIEW_SUPPLIER;
        protected Supplier<CompletableFuture<JobsOverview>> requestOverviewForAllJobsSupplier;
        protected Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceGatewaysSupplier = DEFAULT_REQUEST_METRIC_QUERY_SERVICE_PATHS_SUPPLIER;
        protected Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceGatewaysSupplier = DEFAULT_REQUEST_TASK_MANAGER_METRIC_QUERY_SERVICE_PATHS_SUPPLIER;
        protected Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier;
        protected BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction = DEFAULT_TRIGGER_SAVEPOINT_FUNCTION;
        protected BiFunction<JobID, String, CompletableFuture<String>> stopWithSavepointFunction = DEFAULT_STOP_WITH_SAVEPOINT_FUNCTION;
        protected TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction;

        protected AbstractBuilder() {
            this.clusterShutdownSupplier = DEFAULT_CLUSTER_SHUTDOWN_SUPPLIER;
            this.deliverCoordinationRequestToCoordinatorFunction = DEFAULT_DELIVER_COORDINATION_REQUEST_TO_COORDINATOR_FUNCTION;
        }

        public T setAddress(String address) {
            this.address = address;
            return this.self();
        }

        public T setHostname(String hostname) {
            this.hostname = hostname;
            return this.self();
        }

        public T setClusterShutdownSupplier(Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier) {
            this.clusterShutdownSupplier = clusterShutdownSupplier;
            return this.self();
        }

        public T setRequestJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            this.requestJobFunction = requestJobFunction;
            return this.self();
        }

        public T setRequestExecutionGraphInfoFunction(Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction) {
            this.requestExecutionGraphInfoFunction = requestExecutionGraphInfoFunction;
            return this.self();
        }

        public T setRequestJobResultFunction(Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction) {
            this.requestJobResultFunction = requestJobResultFunction;
            return this.self();
        }

        public T setRequestJobStatusFunction(Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction) {
            this.requestJobStatusFunction = requestJobStatusFunction;
            return this.self();
        }

        public T setRequestMultipleJobDetailsSupplier(Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier) {
            this.requestMultipleJobDetailsSupplier = requestMultipleJobDetailsSupplier;
            return this.self();
        }

        public T setRequestClusterOverviewSupplier(Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier) {
            this.requestClusterOverviewSupplier = requestClusterOverviewSupplier;
            return this.self();
        }

        public T setRequestMetricQueryServiceGatewaysSupplier(Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceGatewaysSupplier) {
            this.requestMetricQueryServiceGatewaysSupplier = requestMetricQueryServiceGatewaysSupplier;
            return this.self();
        }

        public T setRequestTaskManagerMetricQueryServiceGatewaysSupplier(Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceGatewaysSupplier) {
            this.requestTaskManagerMetricQueryServiceGatewaysSupplier = requestTaskManagerMetricQueryServiceGatewaysSupplier;
            return this.self();
        }

        public T setCancelJobFunction(Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction) {
            this.cancelJobFunction = cancelJobFunction;
            return this.self();
        }

        public T setTriggerSavepointFunction(BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction) {
            this.triggerSavepointFunction = triggerSavepointFunction;
            return this.self();
        }

        public T setStopWithSavepointFunction(BiFunction<JobID, String, CompletableFuture<String>> stopWithSavepointFunction) {
            this.stopWithSavepointFunction = stopWithSavepointFunction;
            return this.self();
        }

        public T setDeliverCoordinationRequestToCoordinatorFunction(TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction) {
            this.deliverCoordinationRequestToCoordinatorFunction = deliverCoordinationRequestToCoordinatorFunction;
            return this.self();
        }

        protected abstract T self();

        public abstract TestingRestfulGateway build();
    }
}

