/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.util.Preconditions;

public class CheckpointMetaData
implements Serializable {
    private static final long serialVersionUID = -2387652345781312442L;
    private final long checkpointId;
    private final long timestamp;
    private final CheckpointMetrics metrics;

    public CheckpointMetaData(long checkpointId, long timestamp) {
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.metrics = new CheckpointMetrics();
    }

    public CheckpointMetaData(long checkpointId, long timestamp, long synchronousDurationMillis, long asynchronousDurationMillis, long bytesBufferedInAlignment, long alignmentDurationNanos) {
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.metrics = new CheckpointMetrics(bytesBufferedInAlignment, alignmentDurationNanos, synchronousDurationMillis, asynchronousDurationMillis);
    }

    public CheckpointMetaData(long checkpointId, long timestamp, CheckpointMetrics metrics) {
        this.checkpointId = checkpointId;
        this.timestamp = timestamp;
        this.metrics = (CheckpointMetrics)Preconditions.checkNotNull((Object)metrics);
    }

    public CheckpointMetrics getMetrics() {
        return this.metrics;
    }

    public CheckpointMetaData setBytesBufferedInAlignment(long bytesBufferedInAlignment) {
        Preconditions.checkArgument((bytesBufferedInAlignment >= 0L ? 1 : 0) != 0);
        this.metrics.setBytesBufferedInAlignment(bytesBufferedInAlignment);
        return this;
    }

    public CheckpointMetaData setAlignmentDurationNanos(long alignmentDurationNanos) {
        Preconditions.checkArgument((alignmentDurationNanos >= 0L ? 1 : 0) != 0);
        this.metrics.setAlignmentDurationNanos(alignmentDurationNanos);
        return this;
    }

    public CheckpointMetaData setSyncDurationMillis(long syncDurationMillis) {
        Preconditions.checkArgument((syncDurationMillis >= 0L ? 1 : 0) != 0);
        this.metrics.setSyncDurationMillis(syncDurationMillis);
        return this;
    }

    public CheckpointMetaData setAsyncDurationMillis(long asyncDurationMillis) {
        Preconditions.checkArgument((asyncDurationMillis >= 0L ? 1 : 0) != 0);
        this.metrics.setAsyncDurationMillis(asyncDurationMillis);
        return this;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getBytesBufferedInAlignment() {
        return this.metrics.getBytesBufferedInAlignment();
    }

    public long getAlignmentDurationNanos() {
        return this.metrics.getAlignmentDurationNanos();
    }

    public long getSyncDurationMillis() {
        return this.metrics.getSyncDurationMillis();
    }

    public long getAsyncDurationMillis() {
        return this.metrics.getAsyncDurationMillis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetaData that = (CheckpointMetaData)o;
        return this.checkpointId == that.checkpointId && this.timestamp == that.timestamp && this.metrics.equals(that.metrics);
    }

    public int hashCode() {
        int result = (int)(this.checkpointId ^ this.checkpointId >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.metrics.hashCode();
        return result;
    }

    public String toString() {
        return "CheckpointMetaData{checkpointId=" + this.checkpointId + ", timestamp=" + this.timestamp + ", metrics=" + this.metrics + '}';
    }
}

