/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;

public class CheckpointMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long bytesBufferedInAlignment;
    private long alignmentDurationNanos;
    private long syncDurationMillis;
    private long asyncDurationMillis;

    public CheckpointMetrics() {
        this(-1L, -1L, -1L, -1L);
    }

    public CheckpointMetrics(long bytesBufferedInAlignment, long alignmentDurationNanos, long syncDurationMillis, long asyncDurationMillis) {
        this.bytesBufferedInAlignment = bytesBufferedInAlignment;
        this.alignmentDurationNanos = alignmentDurationNanos;
        this.syncDurationMillis = syncDurationMillis;
        this.asyncDurationMillis = asyncDurationMillis;
    }

    public long getBytesBufferedInAlignment() {
        return this.bytesBufferedInAlignment;
    }

    public void setBytesBufferedInAlignment(long bytesBufferedInAlignment) {
        this.bytesBufferedInAlignment = bytesBufferedInAlignment;
    }

    public long getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public void setAlignmentDurationNanos(long alignmentDurationNanos) {
        this.alignmentDurationNanos = alignmentDurationNanos;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public void setSyncDurationMillis(long syncDurationMillis) {
        this.syncDurationMillis = syncDurationMillis;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public void setAsyncDurationMillis(long asyncDurationMillis) {
        this.asyncDurationMillis = asyncDurationMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetrics that = (CheckpointMetrics)o;
        if (this.bytesBufferedInAlignment != that.bytesBufferedInAlignment) {
            return false;
        }
        if (this.alignmentDurationNanos != that.alignmentDurationNanos) {
            return false;
        }
        if (this.syncDurationMillis != that.syncDurationMillis) {
            return false;
        }
        return this.asyncDurationMillis == that.asyncDurationMillis;
    }

    public int hashCode() {
        int result = (int)(this.bytesBufferedInAlignment ^ this.bytesBufferedInAlignment >>> 32);
        result = 31 * result + (int)(this.alignmentDurationNanos ^ this.alignmentDurationNanos >>> 32);
        result = 31 * result + (int)(this.syncDurationMillis ^ this.syncDurationMillis >>> 32);
        result = 31 * result + (int)(this.asyncDurationMillis ^ this.asyncDurationMillis >>> 32);
        return result;
    }

    public String toString() {
        return "CheckpointMetrics{bytesBufferedInAlignment=" + this.bytesBufferedInAlignment + ", alignmentDurationNanos=" + this.alignmentDurationNanos + ", syncDurationMillis=" + this.syncDurationMillis + ", asyncDurationMillis=" + this.asyncDurationMillis + '}';
    }
}

