/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.apache.flink.runtime.checkpoint.CheckpointStatsHistory;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummary;
import org.apache.flink.runtime.checkpoint.FailedCheckpointStats;
import org.apache.flink.runtime.checkpoint.PendingCheckpointStats;
import org.apache.flink.runtime.checkpoint.RestoredCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskStateStats;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.JobSnapshottingSettings;
import org.apache.flink.util.Preconditions;

public class CheckpointStatsTracker
implements Serializable {
    private static final long serialVersionUID = 1694085244807339288L;
    private final ReentrantLock statsReadWriteLock = new ReentrantLock();
    private final List<ExecutionJobVertex> jobVertices;
    private final int totalSubtaskCount;
    private final JobSnapshottingSettings jobSnapshottingSettings;
    private final CheckpointStatsCounts counts = new CheckpointStatsCounts();
    private final CompletedCheckpointStatsSummary summary = new CompletedCheckpointStatsSummary();
    private final CheckpointStatsHistory history;
    @Nullable
    private RestoredCheckpointStats latestRestoredCheckpoint;
    private volatile CheckpointStatsSnapshot latestSnapshot;
    private volatile boolean dirty;
    @VisibleForTesting
    static final String NUMBER_OF_CHECKPOINTS_METRIC = "totalNumberOfCheckpoints";
    @VisibleForTesting
    static final String NUMBER_OF_IN_PROGRESS_CHECKPOINTS_METRIC = "numberOfInProgressCheckpoints";
    @VisibleForTesting
    static final String NUMBER_OF_COMPLETED_CHECKPOINTS_METRIC = "numberOfCompletedCheckpoints";
    @VisibleForTesting
    static final String NUMBER_OF_FAILED_CHECKPOINTS_METRIC = "numberOfFailedCheckpoints";
    @VisibleForTesting
    static final String LATEST_RESTORED_CHECKPOINT_TIMESTAMP_METRIC = "lastCheckpointRestoreTimestamp";
    @VisibleForTesting
    static final String LATEST_COMPLETED_CHECKPOINT_SIZE_METRIC = "lastCheckpointSize";
    @VisibleForTesting
    static final String LATEST_COMPLETED_CHECKPOINT_DURATION_METRIC = "lastCheckpointDuration";
    @VisibleForTesting
    static final String LATEST_COMPLETED_CHECKPOINT_ALIGNMENT_BUFFERED_METRIC = "lastCheckpointAlignmentBuffered";
    @VisibleForTesting
    static final String LATEST_COMPLETED_CHECKPOINT_EXTERNAL_PATH_METRIC = "lastCheckpointExternalPath";

    public CheckpointStatsTracker(int numRememberedCheckpoints, List<ExecutionJobVertex> jobVertices, JobSnapshottingSettings jobSnapshottingSettings, MetricGroup metricGroup) {
        Preconditions.checkArgument((numRememberedCheckpoints >= 0 ? 1 : 0) != 0, (Object)"Negative number of remembered checkpoints");
        this.history = new CheckpointStatsHistory(numRememberedCheckpoints);
        this.jobVertices = (List)Preconditions.checkNotNull(jobVertices, (String)"JobVertices");
        this.jobSnapshottingSettings = (JobSnapshottingSettings)Preconditions.checkNotNull((Object)jobSnapshottingSettings);
        int count = 0;
        for (ExecutionJobVertex vertex : jobVertices) {
            count += vertex.getParallelism();
        }
        this.totalSubtaskCount = count;
        this.latestSnapshot = new CheckpointStatsSnapshot(this.counts.createSnapshot(), this.summary.createSnapshot(), this.history.createSnapshot(), null);
        this.registerMetrics(metricGroup);
    }

    public JobSnapshottingSettings getSnapshottingSettings() {
        return this.jobSnapshottingSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointStatsSnapshot createSnapshot() {
        CheckpointStatsSnapshot snapshot = this.latestSnapshot;
        if (this.dirty && this.statsReadWriteLock.tryLock()) {
            try {
                this.latestSnapshot = snapshot = new CheckpointStatsSnapshot(this.counts.createSnapshot(), this.summary.createSnapshot(), this.history.createSnapshot(), this.latestRestoredCheckpoint);
                this.dirty = false;
            }
            finally {
                this.statsReadWriteLock.unlock();
            }
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingCheckpointStats reportPendingCheckpoint(long checkpointId, long triggerTimestamp, CheckpointProperties props) {
        ConcurrentHashMap<JobVertexID, TaskStateStats> taskStateStats = this.createEmptyTaskStateStatsMap();
        PendingCheckpointStats pending = new PendingCheckpointStats(checkpointId, triggerTimestamp, props, this.totalSubtaskCount, taskStateStats, new PendingCheckpointStatsCallback());
        this.statsReadWriteLock.lock();
        try {
            this.counts.incrementInProgressCheckpoints();
            this.history.addInProgressCheckpoint(pending);
            this.dirty = true;
        }
        finally {
            this.statsReadWriteLock.unlock();
        }
        return pending;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportRestoredCheckpoint(RestoredCheckpointStats restored) {
        Preconditions.checkNotNull((Object)restored, (String)"Restored checkpoint");
        this.statsReadWriteLock.lock();
        try {
            this.counts.incrementRestoredCheckpoints();
            this.latestRestoredCheckpoint = restored;
            this.dirty = true;
        }
        finally {
            this.statsReadWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCompletedCheckpoint(CompletedCheckpointStats completed) {
        this.statsReadWriteLock.lock();
        try {
            this.counts.incrementCompletedCheckpoints();
            this.history.replacePendingCheckpointById(completed);
            this.summary.updateSummary(completed);
            this.dirty = true;
        }
        finally {
            this.statsReadWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportFailedCheckpoint(FailedCheckpointStats failed) {
        this.statsReadWriteLock.lock();
        try {
            this.counts.incrementFailedCheckpoints();
            this.history.replacePendingCheckpointById(failed);
            this.dirty = true;
        }
        finally {
            this.statsReadWriteLock.unlock();
        }
    }

    private ConcurrentHashMap<JobVertexID, TaskStateStats> createEmptyTaskStateStatsMap() {
        ConcurrentHashMap<JobVertexID, TaskStateStats> taskStatsMap = new ConcurrentHashMap<JobVertexID, TaskStateStats>(this.jobVertices.size());
        for (ExecutionJobVertex vertex : this.jobVertices) {
            TaskStateStats taskStats = new TaskStateStats(vertex.getJobVertexId(), vertex.getParallelism());
            taskStatsMap.put(vertex.getJobVertexId(), taskStats);
        }
        return taskStatsMap;
    }

    private void registerMetrics(MetricGroup metricGroup) {
        metricGroup.gauge(NUMBER_OF_CHECKPOINTS_METRIC, (Gauge)new CheckpointsCounter());
        metricGroup.gauge(NUMBER_OF_IN_PROGRESS_CHECKPOINTS_METRIC, (Gauge)new InProgressCheckpointsCounter());
        metricGroup.gauge(NUMBER_OF_COMPLETED_CHECKPOINTS_METRIC, (Gauge)new CompletedCheckpointsCounter());
        metricGroup.gauge(NUMBER_OF_FAILED_CHECKPOINTS_METRIC, (Gauge)new FailedCheckpointsCounter());
        metricGroup.gauge(LATEST_RESTORED_CHECKPOINT_TIMESTAMP_METRIC, (Gauge)new LatestRestoredCheckpointTimestampGauge());
        metricGroup.gauge(LATEST_COMPLETED_CHECKPOINT_SIZE_METRIC, (Gauge)new LatestCompletedCheckpointSizeGauge());
        metricGroup.gauge(LATEST_COMPLETED_CHECKPOINT_DURATION_METRIC, (Gauge)new LatestCompletedCheckpointDurationGauge());
        metricGroup.gauge(LATEST_COMPLETED_CHECKPOINT_ALIGNMENT_BUFFERED_METRIC, (Gauge)new LatestCompletedCheckpointAlignmentBufferedGauge());
        metricGroup.gauge(LATEST_COMPLETED_CHECKPOINT_EXTERNAL_PATH_METRIC, (Gauge)new LatestCompletedCheckpointExternalPathGauge());
    }

    private class LatestCompletedCheckpointExternalPathGauge
    implements Gauge<String> {
        private LatestCompletedCheckpointExternalPathGauge() {
        }

        public String getValue() {
            CompletedCheckpointStats completed = CheckpointStatsTracker.this.latestSnapshot.getHistory().getLatestCompletedCheckpoint();
            if (completed != null) {
                return completed.getExternalPath();
            }
            return "n/a";
        }
    }

    private class LatestCompletedCheckpointAlignmentBufferedGauge
    implements Gauge<Long> {
        private LatestCompletedCheckpointAlignmentBufferedGauge() {
        }

        public Long getValue() {
            CompletedCheckpointStats completed = CheckpointStatsTracker.this.latestSnapshot.getHistory().getLatestCompletedCheckpoint();
            if (completed != null) {
                return completed.getAlignmentBuffered();
            }
            return -1L;
        }
    }

    private class LatestCompletedCheckpointDurationGauge
    implements Gauge<Long> {
        private LatestCompletedCheckpointDurationGauge() {
        }

        public Long getValue() {
            CompletedCheckpointStats completed = CheckpointStatsTracker.this.latestSnapshot.getHistory().getLatestCompletedCheckpoint();
            if (completed != null) {
                return completed.getEndToEndDuration();
            }
            return -1L;
        }
    }

    private class LatestCompletedCheckpointSizeGauge
    implements Gauge<Long> {
        private LatestCompletedCheckpointSizeGauge() {
        }

        public Long getValue() {
            CompletedCheckpointStats completed = CheckpointStatsTracker.this.latestSnapshot.getHistory().getLatestCompletedCheckpoint();
            if (completed != null) {
                return completed.getStateSize();
            }
            return -1L;
        }
    }

    private class LatestRestoredCheckpointTimestampGauge
    implements Gauge<Long> {
        private LatestRestoredCheckpointTimestampGauge() {
        }

        public Long getValue() {
            RestoredCheckpointStats restored = CheckpointStatsTracker.this.latestRestoredCheckpoint;
            if (restored != null) {
                return restored.getRestoreTimestamp();
            }
            return -1L;
        }
    }

    private class FailedCheckpointsCounter
    implements Gauge<Long> {
        private FailedCheckpointsCounter() {
        }

        public Long getValue() {
            return CheckpointStatsTracker.this.counts.getNumberOfFailedCheckpoints();
        }
    }

    private class CompletedCheckpointsCounter
    implements Gauge<Long> {
        private CompletedCheckpointsCounter() {
        }

        public Long getValue() {
            return CheckpointStatsTracker.this.counts.getNumberOfCompletedCheckpoints();
        }
    }

    private class InProgressCheckpointsCounter
    implements Gauge<Integer> {
        private InProgressCheckpointsCounter() {
        }

        public Integer getValue() {
            return CheckpointStatsTracker.this.counts.getNumberOfInProgressCheckpoints();
        }
    }

    private class CheckpointsCounter
    implements Gauge<Long> {
        private CheckpointsCounter() {
        }

        public Long getValue() {
            return CheckpointStatsTracker.this.counts.getTotalNumberOfCheckpoints();
        }
    }

    class PendingCheckpointStatsCallback {
        PendingCheckpointStatsCallback() {
        }

        void reportCompletedCheckpoint(CompletedCheckpointStats completed) {
            CheckpointStatsTracker.this.reportCompletedCheckpoint(completed);
        }

        void reportFailedCheckpoint(FailedCheckpointStats failed) {
            CheckpointStatsTracker.this.reportFailedCheckpoint(failed);
        }
    }
}

