/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializer;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointSerializers;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointStore {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointStore.class);
    public static final int MAGIC_NUMBER = 1231054637;
    private static final String prefix = "savepoint-";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Savepoint> String storeSavepoint(String targetDirectory, T savepoint) throws IOException {
        Preconditions.checkNotNull((Object)targetDirectory, (String)"Target directory");
        Preconditions.checkNotNull(savepoint, (String)"Savepoint");
        Exception latestException = null;
        Path path = null;
        FSDataOutputStream fdos = null;
        FileSystem fs = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            path = new Path(targetDirectory, FileUtils.getRandomFilename((String)prefix));
            if (fs == null) {
                fs = FileSystem.get((URI)path.toUri());
            }
            try {
                fdos = fs.create(path, false);
                break;
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
        }
        if (fdos == null) {
            throw new IOException("Failed to create file output stream at " + path, latestException);
        }
        boolean success = false;
        try (DataOutputStream dos = new DataOutputStream((OutputStream)fdos);){
            dos.writeInt(1231054637);
            dos.writeInt(savepoint.getVersion());
            SavepointSerializer<T> serializer = SavepointSerializers.getSerializer(savepoint);
            serializer.serialize(savepoint, dos);
            success = true;
        }
        finally {
            if (!success && fs.exists(path) && !fs.delete(path, true)) {
                LOG.warn("Failed to delete file {} after failed write.", (Object)path);
            }
        }
        return path.toString();
    }

    public static Savepoint loadSavepoint(String path, ClassLoader userClassLoader) throws IOException {
        Preconditions.checkNotNull((Object)path, (String)"Path");
        Throwable throwable = null;
        try (DataInputViewStreamWrapper dis = new DataInputViewStreamWrapper((InputStream)SavepointStore.createFsInputStream(new Path(path)));){
            int magicNumber = dis.readInt();
            if (magicNumber == 1231054637) {
                int version = dis.readInt();
                SavepointSerializer<?> serializer = SavepointSerializers.getSerializer(version);
                Object obj = serializer.deserialize((DataInputStream)dis, userClassLoader);
                return obj;
            }
            try {
                throw new RuntimeException("Unexpected magic number. This is most likely caused by trying to load a Flink 1.0 savepoint. You cannot load a savepoint triggered by Flink 1.0 with this version of Flink. If it is _not_ a Flink 1.0 savepoint, this error indicates that the specified file is not a proper savepoint or the file has been corrupted.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static void removeSavepoint(String path) throws IOException {
        block4: {
            Preconditions.checkNotNull((Object)path, (String)"Path");
            try {
                LOG.info("Removing savepoint: {}.", (Object)path);
                Path filePath = new Path(path);
                FileSystem fs = FileSystem.get((URI)filePath.toUri());
                if (fs.exists(filePath)) {
                    if (!fs.delete(filePath, true)) {
                        throw new IOException("Failed to delete " + filePath + ".");
                    }
                    break block4;
                }
                throw new IllegalArgumentException("Invalid path '" + filePath.toUri() + "'.");
            }
            catch (Throwable t) {
                throw new IOException("Failed to dispose savepoint " + path + ".", t);
            }
        }
    }

    private static FSDataInputStream createFsInputStream(Path path) throws IOException {
        FileSystem fs = FileSystem.get((URI)path.toUri());
        if (fs.exists(path)) {
            return fs.open(path);
        }
        throw new IllegalArgumentException("Invalid path '" + path.toUri() + "'.");
    }
}

