/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent.impl;

import akka.dispatch.Futures;
import java.util.concurrent.CancellationException;
import org.apache.flink.runtime.concurrent.CompletableFuture;
import org.apache.flink.runtime.concurrent.impl.FlinkFuture;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class FlinkCompletableFuture<T>
extends FlinkFuture<T>
implements CompletableFuture<T> {
    private final Promise<T> promise;

    public FlinkCompletableFuture() {
        this.promise = Futures.promise();
        this.scalaFuture = this.promise.future();
    }

    private FlinkCompletableFuture(T value) {
        this.promise = Promise$.MODULE$.successful(value);
        this.scalaFuture = this.promise.future();
    }

    private FlinkCompletableFuture(Throwable t) {
        this.promise = Promise$.MODULE$.failed(t);
        this.scalaFuture = this.promise.future();
    }

    @Override
    public boolean complete(T value) {
        try {
            this.promise.success(value);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean completeExceptionally(Throwable t) {
        Preconditions.checkNotNull((Object)t);
        try {
            this.promise.failure(t);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.completeExceptionally(new CancellationException("Future has been canceled."));
    }

    public static <T> FlinkCompletableFuture<T> completed(T value) {
        return new FlinkCompletableFuture<T>(value);
    }

    public static <T> FlinkCompletableFuture<T> completedExceptionally(Throwable t) {
        return new FlinkCompletableFuture<T>(t);
    }
}

