/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.HadoopFileSystemWrapper;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.fs.hdfs.HadoopBlockLocation;
import org.apache.flink.runtime.fs.hdfs.HadoopDataInputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopFileStatus;
import org.apache.flink.util.InstantiationUtil;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopFileSystem
extends FileSystem
implements HadoopFileSystemWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopFileSystem.class);
    private static final String DEFAULT_HDFS_CLASS = "org.apache.hadoop.hdfs.DistributedFileSystem";
    private static final String HDFS_IMPLEMENTATION_KEY = "fs.hdfs.impl";
    private final org.apache.hadoop.conf.Configuration conf = HadoopFileSystem.getHadoopConfiguration();
    private final org.apache.hadoop.fs.FileSystem fs;

    public HadoopFileSystem(Class<? extends org.apache.hadoop.fs.FileSystem> fsClass) throws IOException {
        if (fsClass == null) {
            fsClass = this.getDefaultHDFSClass();
        }
        this.fs = this.instantiateFileSystem(fsClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<? extends org.apache.hadoop.fs.FileSystem> getDefaultHDFSClass() throws IOException {
        Class classFromConfig;
        Class<org.apache.hadoop.fs.FileSystem> fsClass = null;
        LOG.debug("Trying to load HDFS class Hadoop 2.x style.");
        Object fsHandle = null;
        try {
            Method newApi = org.apache.hadoop.fs.FileSystem.class.getMethod("getFileSystemClass", String.class, org.apache.hadoop.conf.Configuration.class);
            fsHandle = newApi.invoke(null, "hdfs", this.conf);
        }
        catch (Exception newApi) {
            // empty catch block
        }
        if (fsHandle != null) {
            if (fsHandle instanceof Class && org.apache.hadoop.fs.FileSystem.class.isAssignableFrom((Class)fsHandle)) {
                fsClass = ((Class)fsHandle).asSubclass(org.apache.hadoop.fs.FileSystem.class);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Loaded '{}' as HDFS class.", (Object)fsClass.getName());
                }
            } else {
                LOG.debug("Unexpected return type from 'org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration)'.");
                throw new RuntimeException("The value returned from org.apache.hadoop.fs.FileSystem.getFileSystemClass(String, Configuration) is not a valid subclass of org.apache.hadoop.fs.FileSystem.");
            }
        }
        if (fsClass != null) return fsClass;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Falling back to loading HDFS class old Hadoop style. Looking for HDFS class configuration entry '{}'.", (Object)HDFS_IMPLEMENTATION_KEY);
        }
        if ((classFromConfig = this.conf.getClass(HDFS_IMPLEMENTATION_KEY, null)) != null) {
            if (!org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(classFromConfig)) {
                if (!LOG.isDebugEnabled()) throw new IOException("HDFS class specified by fs.hdfs.impl cannot be cast to a FileSystem type.");
                LOG.debug("HDFS class specified by {} is of wrong type.", (Object)HDFS_IMPLEMENTATION_KEY);
                throw new IOException("HDFS class specified by fs.hdfs.impl cannot be cast to a FileSystem type.");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load default HDFS implementation {}.", (Object)DEFAULT_HDFS_CLASS);
            }
            try {
                Class<?> reflectedClass = Class.forName(DEFAULT_HDFS_CLASS);
                if (org.apache.hadoop.fs.FileSystem.class.isAssignableFrom(reflectedClass)) {
                    return reflectedClass.asSubclass(org.apache.hadoop.fs.FileSystem.class);
                }
                if (!LOG.isDebugEnabled()) throw new IOException("The default HDFS class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be cast to a FileSystem type.");
                LOG.debug("Default HDFS class is of wrong type.");
                throw new IOException("The default HDFS class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be cast to a FileSystem type.");
            }
            catch (ClassNotFoundException e) {
                if (!LOG.isDebugEnabled()) throw new IOException("No HDFS class has been configured and the default class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be loaded.");
                LOG.debug("Default HDFS class cannot be loaded.");
                throw new IOException("No HDFS class has been configured and the default class 'org.apache.hadoop.hdfs.DistributedFileSystem' cannot be loaded.");
            }
        }
        fsClass = classFromConfig.asSubclass(org.apache.hadoop.fs.FileSystem.class);
        if (!LOG.isDebugEnabled()) return fsClass;
        LOG.debug("Loaded HDFS class '{}' as specified in configuration.", (Object)fsClass.getName());
        return fsClass;
    }

    public static org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        Configuration flinkConfiguration = GlobalConfiguration.loadConfiguration();
        org.apache.hadoop.conf.Configuration retConf = new org.apache.hadoop.conf.Configuration();
        String hdfsDefaultPath = flinkConfiguration.getString("fs.hdfs.hdfsdefault", null);
        if (hdfsDefaultPath != null) {
            retConf.addResource(new org.apache.hadoop.fs.Path(hdfsDefaultPath));
        } else {
            LOG.trace("{} configuration key for hdfs-default configuration file not set", (Object)"fs.hdfs.hdfsdefault");
        }
        String hdfsSitePath = flinkConfiguration.getString("fs.hdfs.hdfssite", null);
        if (hdfsSitePath != null) {
            retConf.addResource(new org.apache.hadoop.fs.Path(hdfsSitePath));
        } else {
            LOG.trace("{} configuration key for hdfs-site configuration file not set", (Object)"fs.hdfs.hdfssite");
        }
        String[] possibleHadoopConfPaths = new String[4];
        possibleHadoopConfPaths[0] = flinkConfiguration.getString("fs.hdfs.hadoopconf", null);
        possibleHadoopConfPaths[1] = System.getenv("HADOOP_CONF_DIR");
        if (System.getenv("HADOOP_HOME") != null) {
            possibleHadoopConfPaths[2] = System.getenv("HADOOP_HOME") + "/conf";
            possibleHadoopConfPaths[3] = System.getenv("HADOOP_HOME") + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (possibleHadoopConfPath == null || !new File(possibleHadoopConfPath).exists()) continue;
            if (new File(possibleHadoopConfPath + "/core-site.xml").exists()) {
                retConf.addResource(new org.apache.hadoop.fs.Path(possibleHadoopConfPath + "/core-site.xml"));
            } else {
                LOG.debug("File {}/core-site.xml not found.", (Object)possibleHadoopConfPath);
            }
            if (new File(possibleHadoopConfPath + "/hdfs-site.xml").exists()) {
                retConf.addResource(new org.apache.hadoop.fs.Path(possibleHadoopConfPath + "/hdfs-site.xml"));
                continue;
            }
            LOG.debug("File {}/hdfs-site.xml not found.", (Object)possibleHadoopConfPath);
        }
        return retConf;
    }

    private org.apache.hadoop.fs.FileSystem instantiateFileSystem(Class<? extends org.apache.hadoop.fs.FileSystem> fsClass) throws IOException {
        try {
            return fsClass.newInstance();
        }
        catch (ExceptionInInitializerError e) {
            throw new IOException("The filesystem class '" + fsClass.getName() + "' throw an exception upon initialization.", e.getException());
        }
        catch (Throwable t) {
            String errorMessage = InstantiationUtil.checkForInstantiationError(fsClass);
            if (errorMessage != null) {
                throw new IOException("The filesystem class '" + fsClass.getName() + "' cannot be instantiated: " + errorMessage);
            }
            throw new IOException("An error occurred while instantiating the filesystem class '" + fsClass.getName() + "'.", t);
        }
    }

    public Path getWorkingDirectory() {
        return new Path(this.fs.getWorkingDirectory().toUri());
    }

    public Path getHomeDirectory() {
        return new Path(this.fs.getHomeDirectory().toUri());
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public org.apache.hadoop.fs.FileSystem getHadoopFileSystem() {
        return this.fs;
    }

    public void initialize(URI path) throws IOException {
        block13: {
            if (path.getAuthority() == null) {
                String configEntry = this.conf.get("fs.defaultFS", null);
                if (configEntry == null) {
                    configEntry = this.conf.get("fs.default.name", null);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("fs.defaultFS is set to {}", (Object)configEntry);
                }
                if (configEntry == null) {
                    throw new IOException(HadoopFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default file system (hdfs) configuration was registered, " + "or that configuration did not contain an entry for the default file system (usually 'fs.defaultFS').");
                }
                try {
                    URI initURI = URI.create(configEntry);
                    if (initURI.getAuthority() == null) {
                        throw new IOException(HadoopFileSystem.getMissingAuthorityErrorPrefix(path) + "Either no default file system was registered, " + "or the provided configuration contains no valid authority component (fs.default.name or fs.defaultFS) " + "describing the (hdfs namenode) host and port.");
                    }
                    try {
                        this.fs.initialize(initURI, this.conf);
                        break block13;
                    }
                    catch (IOException e) {
                        throw new IOException(HadoopFileSystem.getMissingAuthorityErrorPrefix(path) + "Could not initialize the file system connection with the given default file system address: " + e.getMessage(), e);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(HadoopFileSystem.getMissingAuthorityErrorPrefix(path) + "The configuration contains an invalid file system default name (fs.default.name or fs.defaultFS): " + configEntry);
                }
            }
            try {
                this.fs.initialize(path, this.conf);
            }
            catch (UnknownHostException e) {
                String message = "The (HDFS NameNode) host at '" + path.getAuthority() + "', specified by file path '" + path.toString() + "', cannot be resolved" + (e.getMessage() != null ? ": " + e.getMessage() : ".");
                if (path.getPort() == -1) {
                    message = message + " Hint: Have you forgotten a slash? (correct URI would be 'hdfs:///" + path.getAuthority() + path.getPath() + "' ?)";
                }
                throw new IOException(message, e);
            }
            catch (Exception e) {
                throw new IOException("The given file URI (" + path.toString() + ") points to the HDFS NameNode at " + path.getAuthority() + ", but the File System could not be initialized with that address" + (e.getMessage() != null ? ": " + e.getMessage() : "."), e);
            }
        }
    }

    private static String getMissingAuthorityErrorPrefix(URI path) {
        return "The given HDFS file URI (" + path.toString() + ") did not describe the HDFS NameNode." + " The attempt to use a default HDFS configuration, as specified in the '" + "fs.hdfs.hdfsdefault" + "' or '" + "fs.hdfs.hdfssite" + "' config parameter failed due to the following problem: ";
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(new org.apache.hadoop.fs.Path(f.toString()));
        return new HadoopFileStatus(status);
    }

    public org.apache.flink.core.fs.BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (!(file instanceof HadoopFileStatus)) {
            throw new IOException("file is not an instance of DistributedFileStatus");
        }
        HadoopFileStatus f = (HadoopFileStatus)file;
        BlockLocation[] blkLocations = this.fs.getFileBlockLocations(f.getInternalFileStatus(), start, len);
        org.apache.flink.core.fs.BlockLocation[] distBlkLocations = new HadoopBlockLocation[blkLocations.length];
        for (int i = 0; i < distBlkLocations.length; ++i) {
            distBlkLocations[i] = new HadoopBlockLocation(blkLocations[i]);
        }
        return distBlkLocations;
    }

    public HadoopDataInputStream open(Path f, int bufferSize) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path, bufferSize);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataInputStream open(Path f) throws IOException {
        org.apache.hadoop.fs.Path path = new org.apache.hadoop.fs.Path(f.toString());
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream fdos = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite, bufferSize, replication, blockSize);
        return new HadoopDataOutputStream(fdos);
    }

    public HadoopDataOutputStream create(Path f, boolean overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(new org.apache.hadoop.fs.Path(f.toString()), overwrite);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(new org.apache.hadoop.fs.Path(f.toString()), recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(new org.apache.hadoop.fs.Path(f.toString()));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = new HadoopFileStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(new org.apache.hadoop.fs.Path(f.toString()));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(new org.apache.hadoop.fs.Path(src.toString()), new org.apache.hadoop.fs.Path(dst.toString()));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public boolean isDistributedFS() {
        return true;
    }

    public Class<?> getHadoopWrapperClassNameForFileSystem(String scheme) {
        org.apache.hadoop.conf.Configuration hadoopConf = HadoopFileSystem.getHadoopConfiguration();
        Class clazz = hadoopConf.getClass("fs." + scheme + ".impl", null, org.apache.hadoop.fs.FileSystem.class);
        if (clazz != null && LOG.isDebugEnabled()) {
            LOG.debug("Flink supports {} with the Hadoop file system wrapper, impl {}", (Object)scheme, (Object)clazz);
        }
        return clazz;
    }
}

