/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.Serializable;
import java.util.UUID;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.LeaderSessionMessageDecorator;
import org.apache.flink.runtime.messages.MessageDecorator;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;

public class AkkaActorGateway
implements ActorGateway,
Serializable {
    private static final long serialVersionUID = 42L;
    private final ActorRef actor;
    private final UUID leaderSessionID;
    private final MessageDecorator decorator;

    public AkkaActorGateway(ActorRef actor, UUID leaderSessionID) {
        this.actor = actor;
        this.leaderSessionID = leaderSessionID;
        this.decorator = new LeaderSessionMessageDecorator(leaderSessionID);
    }

    @Override
    public Future<Object> ask(Object message, FiniteDuration timeout) {
        Object newMessage = this.decorator.decorate(message);
        return Patterns.ask((ActorRef)this.actor, (Object)newMessage, (Timeout)new Timeout(timeout));
    }

    @Override
    public void tell(Object message) {
        Object newMessage = this.decorator.decorate(message);
        this.actor.tell(newMessage, ActorRef.noSender());
    }

    @Override
    public void tell(Object message, ActorGateway sender) {
        Object newMessage = this.decorator.decorate(message);
        this.actor.tell(newMessage, sender.actor());
    }

    @Override
    public void forward(Object message, ActorGateway sender) {
        Object newMessage = this.decorator.decorate(message);
        this.actor.tell(newMessage, sender.actor());
    }

    @Override
    public Future<Object> retry(Object message, int numberRetries, FiniteDuration timeout, ExecutionContext executionContext) {
        Object newMessage = this.decorator.decorate(message);
        return AkkaUtils.retry(this.actor, newMessage, numberRetries, executionContext, timeout);
    }

    @Override
    public String path() {
        return this.actor.path().toString();
    }

    @Override
    public ActorRef actor() {
        return this.actor;
    }

    @Override
    public UUID leaderSessionID() {
        return this.leaderSessionID;
    }

    public String toString() {
        return String.format("AkkaActorGateway(%s, %s)", this.actor.path(), this.leaderSessionID);
    }
}

