/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.async;

import java.io.Closeable;
import java.io.IOException;
import org.apache.flink.runtime.io.async.StoppableCallbackCallable;

public abstract class AbstractAsyncIOCallable<V, D extends Closeable>
implements StoppableCallbackCallable<V> {
    private volatile boolean stopped = false;
    private volatile D ioHandle;
    private volatile IOException stopException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V call() throws Exception {
        AbstractAsyncIOCallable<V, D> abstractAsyncIOCallable = this;
        synchronized (abstractAsyncIOCallable) {
            if (this.isStopped()) {
                throw new IOException("Task was already stopped. No I/O handle opened.");
            }
            this.ioHandle = this.openIOHandle();
        }
        try {
            abstractAsyncIOCallable = this.performOperation();
            return (V)abstractAsyncIOCallable;
        }
        finally {
            this.closeIOHandle();
        }
    }

    protected abstract D openIOHandle() throws Exception;

    protected abstract V performOperation() throws Exception;

    @Override
    public void stop() {
        this.closeIOHandle();
    }

    private synchronized void closeIOHandle() {
        if (!this.stopped) {
            this.stopped = true;
            D handle = this.ioHandle;
            if (handle != null) {
                try {
                    handle.close();
                }
                catch (IOException ex) {
                    this.stopException = ex;
                }
            }
        }
    }

    protected D getIoHandle() {
        return this.ioHandle;
    }

    @Override
    public void done(boolean canceled) {
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public IOException getStopException() {
        return this.stopException;
    }
}

