/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinedSubpartition
extends ResultSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    private final ArrayDeque<Buffer> buffers = new ArrayDeque();
    private PipelinedSubpartitionView readView;
    private boolean isFinished;
    private volatile boolean isReleased;

    PipelinedSubpartition(int index, ResultPartition parent) {
        super(index, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Buffer buffer) throws IOException {
        PipelinedSubpartitionView reader;
        Preconditions.checkNotNull((Object)buffer);
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isFinished || this.isReleased) {
                return false;
            }
            this.buffers.add(buffer);
            reader = this.readView;
            this.updateStatistics(buffer);
        }
        if (reader != null) {
            reader.notifyBuffersAvailable(1L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        PipelinedSubpartitionView reader;
        Buffer buffer = EventSerializer.toBuffer(EndOfPartitionEvent.INSTANCE);
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isFinished || this.isReleased) {
                return;
            }
            this.buffers.add(buffer);
            reader = this.readView;
            this.updateStatistics(buffer);
            this.isFinished = true;
        }
        LOG.debug("Finished {}.", (Object)this);
        if (reader != null) {
            reader.notifyBuffersAvailable(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PipelinedSubpartitionView view;
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Buffer buffer;
            if (this.isReleased) {
                return;
            }
            while ((buffer = this.buffers.poll()) != null) {
                buffer.recycle();
            }
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        LOG.debug("Released {}.", (Object)this);
        if (view != null) {
            view.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer pollBuffer() {
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this.buffers.pollFirst();
        }
    }

    @Override
    public int releaseMemory() {
        return 0;
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferProvider bufferProvider, BufferAvailabilityListener availabilityListener) throws IOException {
        int queueSize;
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0);
            Preconditions.checkState((this.readView == null ? 1 : 0) != 0, (String)"Subpartition %s of is being (or already has been) consumed, but pipelined subpartitions can only be consumed once.", (Object[])new Object[]{this.index, this.parent.getPartitionId()});
            LOG.debug("Creating read view for subpartition {} of partition {}.", (Object)this.index, (Object)this.parent.getPartitionId());
            queueSize = this.buffers.size();
            this.readView = new PipelinedSubpartitionView(this, availabilityListener);
        }
        this.readView.notifyBuffersAvailable(queueSize);
        return this.readView;
    }

    int getCurrentNumberOfBuffers() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean hasReadView;
        boolean finished;
        long numBytes;
        long numBuffers;
        ArrayDeque<Buffer> arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            numBuffers = this.getTotalNumberOfBuffers();
            numBytes = this.getTotalNumberOfBytes();
            finished = this.isFinished;
            hasReadView = this.readView != null;
        }
        return String.format("PipelinedSubpartition [number of buffers: %d (%d bytes), finished? %s, read view? %s]", numBuffers, numBytes, finished, hasReadView);
    }

    @Override
    public int getNumberOfQueuedBuffers() {
        return this.buffers.size();
    }
}

