/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

class PipelinedSubpartitionView
implements ResultSubpartitionView {
    private final PipelinedSubpartition parent;
    private final BufferAvailabilityListener availabilityListener;
    private final AtomicBoolean isReleased;

    PipelinedSubpartitionView(PipelinedSubpartition parent, BufferAvailabilityListener listener) {
        this.parent = (PipelinedSubpartition)Preconditions.checkNotNull((Object)parent);
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)listener);
        this.isReleased = new AtomicBoolean();
    }

    @Override
    public Buffer getNextBuffer() {
        return this.parent.pollBuffer();
    }

    @Override
    public void notifyBuffersAvailable(long numBuffers) throws IOException {
        this.availabilityListener.notifyBuffersAvailable(numBuffers);
    }

    @Override
    public void notifySubpartitionConsumed() {
        this.releaseAllResources();
    }

    @Override
    public void releaseAllResources() {
        if (this.isReleased.compareAndSet(false, true)) {
            this.parent.onConsumedSubpartition();
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get() || this.parent.isReleased();
    }

    @Override
    public Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    public String toString() {
        return String.format("PipelinedSubpartitionView(index: %d) of ResultPartition %s", this.parent.index, this.parent.parent.getPartitionId());
    }
}

